/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import io.split.client.dtos.Condition;
import io.split.client.dtos.Partition;
import io.split.client.dtos.Split;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.ParserUtils;
import io.split.engine.matchers.CombiningMatcher;
import io.split.engine.matchers.PrerequisitesMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.collect.Lists;

public final class SplitParser {
    private static final Logger _log = LoggerFactory.getLogger(SplitParser.class);

    public ParsedSplit parse(Split split) {
        try {
            return this.parseWithoutExceptionHandling(split);
        }
        catch (Throwable t2) {
            _log.error("Could not parse split: " + split, t2);
            return null;
        }
    }

    private ParsedSplit parseWithoutExceptionHandling(Split split) {
        ArrayList<ParsedCondition> parsedConditionList = Lists.newArrayList();
        if (Objects.isNull(split.impressionsDisabled)) {
            _log.debug("impressionsDisabled field not detected for Feature flag `" + split.name + "`, setting it to `false`.");
            split.impressionsDisabled = false;
        }
        for (Condition condition : split.conditions) {
            List<Partition> partitions = condition.partitions;
            if (ParserUtils.checkUnsupportedMatcherExist(condition.matcherGroup.matchers)) {
                _log.error("Unsupported matcher type found for feature flag: " + split.name + " , will revert to default template matcher.");
                parsedConditionList.clear();
                parsedConditionList.add(ParserUtils.getTemplateCondition());
                break;
            }
            CombiningMatcher matcher = ParserUtils.toMatcher(condition.matcherGroup);
            parsedConditionList.add(new ParsedCondition(condition.conditionType, matcher, partitions, condition.label));
        }
        return new ParsedSplit(split.name, split.seed, split.killed, split.defaultTreatment, parsedConditionList, split.trafficTypeName, split.changeNumber, split.trafficAllocation, split.trafficAllocationSeed, split.algo, split.configurations, split.sets, split.impressionsDisabled, new PrerequisitesMatcher(split.prerequisites));
    }
}

