/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.hc.client5.http.impl.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.hc.client5.http.auth.AuthChallenge;
import split.org.apache.hc.client5.http.auth.AuthScheme;
import split.org.apache.hc.client5.http.auth.AuthScope;
import split.org.apache.hc.client5.http.auth.AuthenticationException;
import split.org.apache.hc.client5.http.auth.Credentials;
import split.org.apache.hc.client5.http.auth.CredentialsProvider;
import split.org.apache.hc.client5.http.auth.MalformedChallengeException;
import split.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import split.org.apache.hc.client5.http.impl.auth.AuthSchemeSupport;
import split.org.apache.hc.client5.http.impl.auth.HttpEntityDigester;
import split.org.apache.hc.client5.http.impl.auth.UnsupportedDigestAlgorithmException;
import split.org.apache.hc.client5.http.protocol.HttpClientContext;
import split.org.apache.hc.client5.http.utils.ByteArrayBuilder;
import split.org.apache.hc.core5.annotation.Internal;
import split.org.apache.hc.core5.http.ClassicHttpRequest;
import split.org.apache.hc.core5.http.HttpEntity;
import split.org.apache.hc.core5.http.HttpHost;
import split.org.apache.hc.core5.http.HttpRequest;
import split.org.apache.hc.core5.http.NameValuePair;
import split.org.apache.hc.core5.http.message.BasicHeaderValueFormatter;
import split.org.apache.hc.core5.http.message.BasicNameValuePair;
import split.org.apache.hc.core5.http.protocol.HttpContext;
import split.org.apache.hc.core5.net.PercentCodec;
import split.org.apache.hc.core5.util.Args;
import split.org.apache.hc.core5.util.CharArrayBuffer;
import split.org.apache.hc.core5.util.TextUtils;

public class DigestScheme
implements AuthScheme,
Serializable {
    private static final long serialVersionUID = 3883908186234566916L;
    private static final Logger LOG = LoggerFactory.getLogger(DigestScheme.class);
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private transient Charset defaultCharset = StandardCharsets.UTF_8;
    private final Map<String, String> paramMap = new HashMap<String, String>();
    private boolean complete = false;
    private transient ByteArrayBuilder buffer;
    private boolean userhashSupported = false;
    private String lastNonce;
    private long nounceCount;
    private String cnonce;
    private byte[] a1;
    private byte[] a2;
    private UsernamePasswordCredentials credentials;

    public DigestScheme() {
    }

    @Deprecated
    public DigestScheme(Charset charset) {
        this();
    }

    public void initPreemptive(Credentials credentials, String cnonce, String realm) {
        Args.notNull(credentials, "Credentials");
        Args.check(credentials instanceof UsernamePasswordCredentials, "Unsupported credential type: " + credentials.getClass());
        this.credentials = (UsernamePasswordCredentials)credentials;
        this.paramMap.put("cnonce", cnonce);
        this.paramMap.put("realm", realm);
    }

    @Override
    public String getName() {
        return "Digest";
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public String getRealm() {
        return this.paramMap.get("realm");
    }

    @Override
    public void processChallenge(AuthChallenge authChallenge, HttpContext context) throws MalformedChallengeException {
        Args.notNull(authChallenge, "AuthChallenge");
        this.paramMap.clear();
        List<NameValuePair> params = authChallenge.getParams();
        if (params != null) {
            for (NameValuePair param : params) {
                this.paramMap.put(param.getName().toLowerCase(Locale.ROOT), param.getValue());
            }
        }
        if (this.paramMap.isEmpty()) {
            throw new MalformedChallengeException("Missing digest auth parameters");
        }
        String userHashValue = this.paramMap.get("userhash");
        this.userhashSupported = "true".equalsIgnoreCase(userHashValue);
        this.complete = true;
    }

    @Override
    public boolean isChallengeComplete() {
        String s2 = this.paramMap.get("stale");
        return !"true".equalsIgnoreCase(s2) && this.complete;
    }

    @Override
    public boolean isResponseReady(HttpHost host, CredentialsProvider credentialsProvider, HttpContext context) throws AuthenticationException {
        Args.notNull(host, "Auth host");
        Args.notNull(credentialsProvider, "CredentialsProvider");
        AuthScope authScope = new AuthScope(host, this.getRealm(), this.getName());
        Credentials credentials = credentialsProvider.getCredentials(authScope, context);
        if (credentials instanceof UsernamePasswordCredentials) {
            this.credentials = (UsernamePasswordCredentials)credentials;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            HttpClientContext clientContext = HttpClientContext.cast(context);
            String exchangeId = clientContext.getExchangeId();
            LOG.debug("{} No credentials found for auth scope [{}]", (Object)exchangeId, (Object)authScope);
        }
        this.credentials = null;
        return false;
    }

    @Override
    public Principal getPrincipal() {
        return null;
    }

    @Override
    public String generateAuthResponse(HttpHost host, HttpRequest request, HttpContext context) throws AuthenticationException {
        HttpClientContext clientContext;
        String nextNonce;
        Args.notNull(request, "HTTP request");
        if (this.paramMap.get("realm") == null) {
            throw new AuthenticationException("missing realm");
        }
        if (this.paramMap.get("nonce") == null) {
            throw new AuthenticationException("missing nonce");
        }
        if (context != null && !TextUtils.isBlank(nextNonce = (clientContext = HttpClientContext.cast(context)).getNextNonce())) {
            this.paramMap.put("nonce", nextNonce);
            clientContext.setNextNonce(null);
        }
        return this.createDigestResponse(request);
    }

    private static MessageDigest createMessageDigest(String digAlg) throws UnsupportedDigestAlgorithmException {
        try {
            return MessageDigest.getInstance(digAlg);
        }
        catch (Exception e) {
            throw new UnsupportedDigestAlgorithmException("Unsupported algorithm in HTTP Digest authentication: " + digAlg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createDigestResponse(HttpRequest request) throws AuthenticationException {
        String usernameForDigest;
        MessageDigest digester;
        if (this.credentials == null) {
            throw new AuthenticationException("User credentials have not been provided");
        }
        String uri = request.getRequestUri();
        String method = request.getMethod();
        String realm = this.paramMap.get("realm");
        String nonce = this.paramMap.get("nonce");
        String opaque = this.paramMap.get("opaque");
        String algorithm = this.paramMap.get("algorithm");
        HashSet<String> qopset = new HashSet<String>(8);
        QualityOfProtection qop = QualityOfProtection.UNKNOWN;
        String qoplist = this.paramMap.get("qop");
        if (qoplist != null) {
            HttpEntity entity;
            StringTokenizer tok = new StringTokenizer(qoplist, ",");
            while (tok.hasMoreTokens()) {
                String variant = tok.nextToken().trim();
                qopset.add(variant.toLowerCase(Locale.ROOT));
            }
            HttpEntity httpEntity = entity = request instanceof ClassicHttpRequest ? ((ClassicHttpRequest)request).getEntity() : null;
            if (entity != null && qopset.contains("auth-int")) {
                qop = QualityOfProtection.AUTH_INT;
            } else if (qopset.contains("auth")) {
                qop = QualityOfProtection.AUTH;
            } else if (qopset.contains("auth-int")) {
                qop = QualityOfProtection.AUTH_INT;
            }
        } else {
            qop = QualityOfProtection.MISSING;
        }
        if (qop == QualityOfProtection.UNKNOWN) {
            throw new AuthenticationException("None of the qop methods is supported: " + qoplist);
        }
        Charset charset = AuthSchemeSupport.parseCharset(this.paramMap.get("charset"), this.defaultCharset);
        DigestAlgorithm digAlg = null;
        try {
            digAlg = DigestAlgorithm.fromString(algorithm == null ? "MD5" : algorithm);
            digester = DigestScheme.createMessageDigest(digAlg.getBaseAlgorithm());
        }
        catch (UnsupportedDigestAlgorithmException ex) {
            throw new AuthenticationException("Unsupported digest algorithm: " + (Object)((Object)digAlg));
        }
        if (nonce.equals(this.lastNonce)) {
            ++this.nounceCount;
        } else {
            this.nounceCount = 1L;
            this.cnonce = null;
            this.lastNonce = nonce;
        }
        StringBuilder sb = new StringBuilder(8);
        try (Formatter formatter = new Formatter(sb, Locale.ROOT);){
            formatter.format("%08x", this.nounceCount);
        }
        String nc = sb.toString();
        if (this.cnonce == null) {
            this.cnonce = DigestScheme.formatHex(DigestScheme.createCnonce(digAlg));
        }
        if (this.buffer == null) {
            this.buffer = new ByteArrayBuilder(128);
        } else {
            this.buffer.reset();
        }
        this.buffer.charset(charset);
        this.a1 = null;
        this.a2 = null;
        String username = this.credentials.getUserName();
        String encodedUsername = null;
        if (username != null && this.containsInvalidABNFChars(username)) {
            encodedUsername = "UTF-8''" + PercentCodec.RFC5987.encode(username);
        }
        if (this.userhashSupported) {
            String usernameRealm = username + ":" + realm;
            byte[] hashedBytes = digester.digest(usernameRealm.getBytes(StandardCharsets.UTF_8));
            username = usernameForDigest = DigestScheme.formatHex(hashedBytes);
        } else {
            usernameForDigest = encodedUsername != null ? encodedUsername : username;
        }
        if (digAlg.isSessionBased()) {
            this.buffer.append(username).append(":").append(realm).append(":").append(this.credentials.getUserPassword());
            String checksum = DigestScheme.formatHex(digester.digest(this.buffer.toByteArray()));
            this.buffer.reset();
            this.buffer.append(checksum).append(":").append(nonce).append(":").append(this.cnonce);
        } else {
            this.buffer.append(username).append(":").append(realm).append(":").append(this.credentials.getUserPassword());
        }
        this.a1 = this.buffer.toByteArray();
        String hasha1 = DigestScheme.formatHex(digester.digest(this.a1));
        this.buffer.reset();
        if (qop == QualityOfProtection.AUTH) {
            this.a2 = this.buffer.append(method).append(":").append(uri).toByteArray();
        } else if (qop == QualityOfProtection.AUTH_INT) {
            HttpEntity entity;
            HttpEntity httpEntity = entity = request instanceof ClassicHttpRequest ? ((ClassicHttpRequest)request).getEntity() : null;
            if (entity != null && !entity.isRepeatable()) {
                if (!qopset.contains("auth")) throw new AuthenticationException("Qop auth-int cannot be used with a non-repeatable entity");
                qop = QualityOfProtection.AUTH;
                this.a2 = this.buffer.append(method).append(":").append(uri).toByteArray();
            } else {
                HttpEntityDigester entityDigester = new HttpEntityDigester(digester);
                try {
                    if (entity != null) {
                        entity.writeTo(entityDigester);
                    }
                    entityDigester.close();
                }
                catch (IOException ex) {
                    throw new AuthenticationException("I/O error reading entity content", ex);
                }
                this.a2 = this.buffer.append(method).append(":").append(uri).append(":").append(DigestScheme.formatHex(entityDigester.getDigest())).toByteArray();
            }
        } else {
            this.a2 = this.buffer.append(method).append(":").append(uri).toByteArray();
        }
        String hasha2 = DigestScheme.formatHex(digester.digest(this.a2));
        this.buffer.reset();
        if (qop == QualityOfProtection.MISSING) {
            this.buffer.append(hasha1).append(":").append(nonce).append(":").append(hasha2);
        } else {
            this.buffer.append(hasha1).append(":").append(nonce).append(":").append(nc).append(":").append(this.cnonce).append(":").append(qop == QualityOfProtection.AUTH_INT ? "auth-int" : "auth").append(":").append(hasha2);
        }
        byte[] digestInput = this.buffer.toByteArray();
        this.buffer.reset();
        String digest = DigestScheme.formatHex(digester.digest(digestInput));
        CharArrayBuffer buffer = new CharArrayBuffer(128);
        buffer.append("Digest ");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(20);
        if (this.userhashSupported) {
            params.add(new BasicNameValuePair("username", usernameForDigest));
            params.add(new BasicNameValuePair("userhash", "true"));
        } else if (encodedUsername != null) {
            params.add(new BasicNameValuePair("username*", encodedUsername));
        } else {
            params.add(new BasicNameValuePair("username", username));
        }
        params.add(new BasicNameValuePair("realm", realm));
        params.add(new BasicNameValuePair("nonce", nonce));
        params.add(new BasicNameValuePair("uri", uri));
        params.add(new BasicNameValuePair("response", digest));
        if (qop != QualityOfProtection.MISSING) {
            params.add(new BasicNameValuePair("qop", qop == QualityOfProtection.AUTH_INT ? "auth-int" : "auth"));
            params.add(new BasicNameValuePair("nc", nc));
            params.add(new BasicNameValuePair("cnonce", this.cnonce));
            params.add(new BasicNameValuePair("rspauth", hasha2));
        }
        if (algorithm != null) {
            params.add(new BasicNameValuePair("algorithm", algorithm));
        }
        if (opaque != null) {
            params.add(new BasicNameValuePair("opaque", opaque));
        }
        for (int i = 0; i < params.size(); ++i) {
            String name;
            BasicNameValuePair param = (BasicNameValuePair)params.get(i);
            if (i > 0) {
                buffer.append(", ");
            }
            boolean noQuotes = "nc".equals(name = param.getName()) || "qop".equals(name) || "algorithm".equals(name);
            BasicHeaderValueFormatter.INSTANCE.formatNameValuePair(buffer, param, !noQuotes);
        }
        return buffer.toString();
    }

    @Internal
    public String getNonce() {
        return this.lastNonce;
    }

    @Internal
    public long getNounceCount() {
        return this.nounceCount;
    }

    @Internal
    public String getCnonce() {
        return this.cnonce;
    }

    String getA1() {
        return this.a1 != null ? new String(this.a1, StandardCharsets.US_ASCII) : null;
    }

    String getA2() {
        return this.a2 != null ? new String(this.a2, StandardCharsets.US_ASCII) : null;
    }

    static String formatHex(byte[] binaryData) {
        int n = binaryData.length;
        char[] buffer = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
        }
        return new String(buffer);
    }

    static byte[] createCnonce(DigestAlgorithm algorithm) {
        int length;
        SecureRandom rnd = new SecureRandom();
        switch (algorithm.name().toUpperCase()) {
            case "SHA-256": 
            case "SHA-512/256": {
                length = 32;
                break;
            }
            default: {
                length = 16;
            }
        }
        byte[] tmp = new byte[length];
        rnd.nextBytes(tmp);
        return tmp;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.defaultCharset.name());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.defaultCharset = Charset.forName(in.readUTF());
    }

    public String toString() {
        return this.getName() + this.paramMap;
    }

    private boolean containsInvalidABNFChars(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Input string should not be null.");
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c <= '\u001f' || c == '\u007f') {
                return true;
            }
            if (c > '~') {
                return true;
            }
            if (c != '\"' && c != '\\') continue;
            return true;
        }
        return false;
    }

    private static enum DigestAlgorithm {
        MD5("MD5", false),
        MD5_SESS("MD5", true),
        SHA_256("SHA-256", false),
        SHA_256_SESS("SHA-256", true),
        SHA_512_256("SHA-512/256", false),
        SHA_512_256_SESS("SHA-512/256", true);

        private final String baseAlgorithm;
        private final boolean sessionBased;

        private DigestAlgorithm(String baseAlgorithm, boolean sessionBased) {
            this.baseAlgorithm = baseAlgorithm;
            this.sessionBased = sessionBased;
        }

        private String getBaseAlgorithm() {
            return this.baseAlgorithm;
        }

        private boolean isSessionBased() {
            return this.sessionBased;
        }

        private static DigestAlgorithm fromString(String algorithm) {
            switch (algorithm.toUpperCase(Locale.ROOT)) {
                case "MD5": {
                    return MD5;
                }
                case "MD5-SESS": {
                    return MD5_SESS;
                }
                case "SHA-256": {
                    return SHA_256;
                }
                case "SHA-256-SESS": {
                    return SHA_256_SESS;
                }
                case "SHA-512/256": 
                case "SHA-512-256": {
                    return SHA_512_256;
                }
                case "SHA-512-256-SESS": {
                    return SHA_512_256_SESS;
                }
            }
            throw new UnsupportedDigestAlgorithmException("Unsupported digest algorithm: " + algorithm);
        }
    }

    private static enum QualityOfProtection {
        UNKNOWN,
        MISSING,
        AUTH_INT,
        AUTH;

    }
}

