/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.cache.InMemoryCacheImp;
import io.split.cache.SegmentCache;
import io.split.cache.SegmentCacheInMemoryImpl;
import io.split.cache.SplitCache;
import io.split.client.ApiKeyCounter;
import io.split.client.EventClient;
import io.split.client.EventClientImpl;
import io.split.client.HttpSegmentChangeFetcher;
import io.split.client.HttpSplitChangeFetcher;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitClientImpl;
import io.split.client.SplitFactory;
import io.split.client.SplitManager;
import io.split.client.SplitManagerImpl;
import io.split.client.impressions.AsynchronousImpressionListener;
import io.split.client.impressions.ImpressionListener;
import io.split.client.impressions.ImpressionsManagerImpl;
import io.split.client.interceptors.AuthorizationInterceptorFilter;
import io.split.client.interceptors.ClientKeyInterceptorFilter;
import io.split.client.interceptors.GzipDecoderResponseInterceptor;
import io.split.client.interceptors.GzipEncoderRequestInterceptor;
import io.split.client.interceptors.SdkMetadataInterceptorFilter;
import io.split.engine.SDKReadinessGates;
import io.split.engine.common.SyncManager;
import io.split.engine.common.SyncManagerImp;
import io.split.engine.evaluator.Evaluator;
import io.split.engine.evaluator.EvaluatorImp;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitFetcherImp;
import io.split.engine.experiments.SplitParser;
import io.split.engine.experiments.SplitSynchronizationTask;
import io.split.engine.segments.SegmentSynchronizationTaskImp;
import io.split.integrations.IntegrationsConfig;
import io.split.telemetry.storage.InMemoryTelemetryStorage;
import io.split.telemetry.storage.TelemetryStorage;
import io.split.telemetry.synchronizer.TelemetrySubmitter;
import io.split.telemetry.synchronizer.TelemetrySyncTask;
import io.split.telemetry.synchronizer.TelemetrySynchronizer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitFactoryImpl
implements SplitFactory {
    private static final Logger _log = LoggerFactory.getLogger(SplitFactory.class);
    private static final long SSE_CONNECT_TIMEOUT = 30000L;
    private static final long SSE_SOCKET_TIMEOUT = 70000L;
    private static Random RANDOM = new Random();
    private final URI _rootTarget;
    private final URI _eventsRootTarget;
    private final CloseableHttpClient _httpclient;
    private final SDKReadinessGates _gates;
    private final SegmentSynchronizationTaskImp _segmentSynchronizationTaskImp;
    private final SplitFetcher _splitFetcher;
    private final SplitSynchronizationTask _splitSynchronizationTask;
    private final ImpressionsManagerImpl _impressionsManager;
    private final EventClient _eventClient;
    private final SyncManager _syncManager;
    private final Evaluator _evaluator;
    private final String _apiToken;
    private final SegmentCache _segmentCache;
    private final SplitCache _splitCache;
    private final SplitClient _client;
    private final SplitManager _manager;
    private boolean isTerminated = false;
    private final ApiKeyCounter _apiKeyCounter;
    private final TelemetryStorage _telemetryStorage;
    private final TelemetrySynchronizer _telemetrySynchronizer;
    private final TelemetrySyncTask _telemetrySyncTask;
    private final long _startTime = System.currentTimeMillis();

    public SplitFactoryImpl(String apiToken, SplitClientConfig config) throws URISyntaxException {
        this._apiToken = apiToken;
        this._apiKeyCounter = ApiKeyCounter.getApiKeyCounterInstance();
        this._apiKeyCounter.add(apiToken);
        this._telemetryStorage = new InMemoryTelemetryStorage();
        if (config.blockUntilReady() == -1) {
            _log.warn("no setBlockUntilReadyTimeout parameter has been set - incorrect control treatments could be logged\u201d if no ready config has been set when building factory");
        }
        this._gates = new SDKReadinessGates();
        this._httpclient = SplitFactoryImpl.buildHttpClient(apiToken, config);
        this._rootTarget = URI.create(config.endpoint());
        this._eventsRootTarget = URI.create(config.eventsEndpoint());
        this._segmentCache = new SegmentCacheInMemoryImpl();
        this._splitCache = new InMemoryCacheImp();
        this._telemetrySynchronizer = new TelemetrySubmitter(this._httpclient, URI.create(config.telemetryURL()), this._telemetryStorage, this._splitCache, this._segmentCache, this._telemetryStorage, this._startTime);
        this._segmentSynchronizationTaskImp = this.buildSegments(config);
        this._splitFetcher = this.buildSplitFetcher();
        this._splitSynchronizationTask = new SplitSynchronizationTask(this._splitFetcher, this._splitCache, SplitFactoryImpl.findPollingPeriod(RANDOM, config.featuresRefreshRate()));
        this._impressionsManager = this.buildImpressionsManager(config);
        this._eventClient = EventClientImpl.create(this._httpclient, this._eventsRootTarget, config.eventsQueueSize(), config.eventFlushIntervalInMillis(), config.waitBeforeShutdown(), this._telemetryStorage);
        this._telemetrySyncTask = new TelemetrySyncTask(config.get_telemetryRefreshRate(), this._telemetrySynchronizer);
        this._evaluator = new EvaluatorImp(this._splitCache);
        this._client = new SplitClientImpl(this, this._splitCache, this._impressionsManager, this._eventClient, config, this._gates, this._evaluator, this._telemetryStorage, this._telemetryStorage);
        this._manager = new SplitManagerImpl(this._splitCache, config, this._gates, this._telemetryStorage);
        this._syncManager = SyncManagerImp.build(config.streamingEnabled(), this._splitSynchronizationTask, this._splitFetcher, this._segmentSynchronizationTaskImp, this._splitCache, config.authServiceURL(), this._httpclient, config.streamingServiceURL(), config.authRetryBackoffBase(), SplitFactoryImpl.buildSSEdHttpClient(apiToken, config), this._segmentCache, config.streamingRetryDelay(), config.streamingFetchMaxRetries(), config.failedAttemptsBeforeLogging(), config.cdnDebugLogging(), this._gates, this._telemetryStorage, this._telemetrySynchronizer, config);
        this._syncManager.start();
        if (config.destroyOnShutDown()) {
            Thread shutdown = new Thread(() -> this.destroy());
            shutdown.setName("split-destroy-worker");
            Runtime.getRuntime().addShutdownHook(shutdown);
        }
    }

    @Override
    public SplitClient client() {
        return this._client;
    }

    @Override
    public SplitManager manager() {
        return this._manager;
    }

    @Override
    public synchronized void destroy() {
        if (!this.isTerminated) {
            _log.info("Shutdown called for split");
            try {
                long splitCount = this._splitCache.getAll().stream().count();
                long segmentCount = this._segmentCache.getAll().stream().count();
                long segmentKeyCount = this._segmentCache.getKeyCount();
                this._impressionsManager.close();
                _log.info("Successful shutdown of impressions manager");
                this._eventClient.close();
                _log.info("Successful shutdown of eventClient");
                this._segmentSynchronizationTaskImp.close();
                _log.info("Successful shutdown of segment fetchers");
                this._splitSynchronizationTask.close();
                _log.info("Successful shutdown of splits");
                this._syncManager.shutdown();
                _log.info("Successful shutdown of syncManager");
                this._telemetryStorage.recordSessionLength(System.currentTimeMillis() - this._startTime);
                this._telemetrySyncTask.stopScheduledTask(splitCount, segmentCount, segmentKeyCount);
                _log.info("Successful shutdown of telemetry sync task");
                this._httpclient.close();
                _log.info("Successful shutdown of httpclient");
            }
            catch (IOException e) {
                _log.error("We could not shutdown split", (Throwable)e);
            }
            this._apiKeyCounter.remove(this._apiToken);
            this.isTerminated = true;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.isTerminated;
    }

    private static CloseableHttpClient buildHttpClient(String apiToken, SplitClientConfig config) {
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(SSLContexts.createSystemDefault()).setTlsVersions(new TLS[]{TLS.V_1_1, TLS.V_1_2}).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)config.connectionTimeout())).setCookieSpec("strict").build();
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)config.readTimeout())).build()).build();
        cm.setMaxTotal(20);
        cm.setDefaultMaxPerRoute(20);
        HttpClientBuilder httpClientbuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).addRequestInterceptorLast((HttpRequestInterceptor)AuthorizationInterceptorFilter.instance(apiToken)).addRequestInterceptorLast((HttpRequestInterceptor)SdkMetadataInterceptorFilter.instance(config.ipAddressEnabled(), SplitClientConfig.splitSdkVersion)).addRequestInterceptorLast((HttpRequestInterceptor)new GzipEncoderRequestInterceptor()).addResponseInterceptorLast((HttpResponseInterceptor)new GzipDecoderResponseInterceptor());
        if (config.proxy() != null) {
            httpClientbuilder = SplitFactoryImpl.setupProxy(httpClientbuilder, config);
        }
        return httpClientbuilder.build();
    }

    private static CloseableHttpClient buildSSEdHttpClient(String apiToken, SplitClientConfig config) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)30000L)).build();
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(SSLContexts.createSystemDefault()).setTlsVersions(new TLS[]{TLS.V_1_1, TLS.V_1_2}).build();
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)70000L)).build()).build();
        cm.setMaxTotal(1);
        cm.setDefaultMaxPerRoute(1);
        HttpClientBuilder httpClientbuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).addRequestInterceptorLast((HttpRequestInterceptor)SdkMetadataInterceptorFilter.instance(config.ipAddressEnabled(), SplitClientConfig.splitSdkVersion)).addRequestInterceptorLast((HttpRequestInterceptor)ClientKeyInterceptorFilter.instance(apiToken));
        if (config.proxy() != null) {
            httpClientbuilder = SplitFactoryImpl.setupProxy(httpClientbuilder, config);
        }
        return httpClientbuilder.build();
    }

    private static HttpClientBuilder setupProxy(HttpClientBuilder httpClientbuilder, SplitClientConfig config) {
        _log.info("Initializing Split SDK with proxy settings");
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(config.proxy());
        httpClientbuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        if (config.proxyUsername() != null && config.proxyPassword() != null) {
            _log.debug("Proxy setup using credentials");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            AuthScope siteScope = new AuthScope(config.proxy().getHostName(), config.proxy().getPort());
            UsernamePasswordCredentials siteCreds = new UsernamePasswordCredentials(config.proxyUsername(), config.proxyPassword().toCharArray());
            credsProvider.setCredentials(siteScope, (Credentials)siteCreds);
            httpClientbuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        return httpClientbuilder;
    }

    private static int findPollingPeriod(Random rand, int max) {
        int min = max / 2;
        return rand.nextInt(max - min + 1) + min;
    }

    private SegmentSynchronizationTaskImp buildSegments(SplitClientConfig config) throws URISyntaxException {
        HttpSegmentChangeFetcher segmentChangeFetcher = HttpSegmentChangeFetcher.create(this._httpclient, this._rootTarget, this._telemetryStorage);
        return new SegmentSynchronizationTaskImp(segmentChangeFetcher, SplitFactoryImpl.findPollingPeriod(RANDOM, config.segmentsRefreshRate()), config.numThreadsForSegmentFetch(), this._gates, this._segmentCache, this._telemetryStorage);
    }

    private SplitFetcher buildSplitFetcher() throws URISyntaxException {
        HttpSplitChangeFetcher splitChangeFetcher = HttpSplitChangeFetcher.create(this._httpclient, this._rootTarget, this._telemetryStorage);
        SplitParser splitParser = new SplitParser(this._segmentSynchronizationTaskImp, this._segmentCache);
        return new SplitFetcherImp(splitChangeFetcher, splitParser, this._splitCache, this._telemetryStorage);
    }

    private ImpressionsManagerImpl buildImpressionsManager(SplitClientConfig config) throws URISyntaxException {
        ArrayList<ImpressionListener> impressionListeners = new ArrayList<ImpressionListener>();
        if (config.integrationsConfig() != null) {
            config.integrationsConfig().getImpressionsListeners(IntegrationsConfig.Execution.ASYNC).stream().map(l -> AsynchronousImpressionListener.build(l.listener(), l.queueSize())).collect(Collectors.toCollection(() -> impressionListeners));
            config.integrationsConfig().getImpressionsListeners(IntegrationsConfig.Execution.SYNC).stream().map(IntegrationsConfig.ImpressionListenerWithMeta::listener).collect(Collectors.toCollection(() -> impressionListeners));
        }
        return ImpressionsManagerImpl.instance(this._httpclient, config, impressionListeners, this._telemetryStorage);
    }
}

