/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.AbstractLocalhostSplitFile;
import io.split.client.LocalhostSplit;
import io.split.client.LocalhostSplitFactory;
import io.split.client.SplitAndKey;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import split.com.google.common.base.Preconditions;
import split.com.google.common.collect.Maps;

public class YamlLocalhostSplitFile
extends AbstractLocalhostSplitFile {
    private static final Logger _log = LoggerFactory.getLogger(YamlLocalhostSplitFile.class);

    public YamlLocalhostSplitFile(LocalhostSplitFactory localhostSplitFactory, String directory, String filenameYaml) throws IOException {
        super(localhostSplitFactory, directory, filenameYaml);
    }

    @Override
    public Map<SplitAndKey, LocalhostSplit> readOnSplits() throws IOException {
        HashMap<SplitAndKey, LocalhostSplit> onSplits = Maps.newHashMap();
        try {
            Yaml yaml = new Yaml();
            List yamlSplits = (List)yaml.load((Reader)new FileReader(this._file));
            for (Map aSplit : yamlSplits) {
                Map.Entry splitAndValues = aSplit.entrySet().iterator().next();
                SplitAndKey splitAndKey = null;
                String splitName = (String)splitAndValues.getKey();
                String treatment = (String)((Map)splitAndValues.getValue()).get("treatment");
                String configurations = ((Map)splitAndValues.getValue()).get("config") != null ? (String)((Map)splitAndValues.getValue()).get("config") : null;
                Object keyOrKeys = ((Map)splitAndValues.getValue()).get("keys");
                if (keyOrKeys == null) {
                    splitAndKey = SplitAndKey.of(splitName);
                    onSplits.put(splitAndKey, LocalhostSplit.of(treatment, configurations));
                    continue;
                }
                if (keyOrKeys instanceof String) {
                    splitAndKey = SplitAndKey.of(splitName, (String)keyOrKeys);
                    onSplits.put(splitAndKey, LocalhostSplit.of(treatment, configurations));
                    continue;
                }
                Preconditions.checkArgument(keyOrKeys instanceof List, "'keys' is not a String nor a List.");
                for (String aKey : (List)keyOrKeys) {
                    splitAndKey = SplitAndKey.of(splitName, aKey);
                    onSplits.put(splitAndKey, LocalhostSplit.of(treatment, configurations));
                }
            }
        }
        catch (Exception e) {
            _log.warn("There was no file named " + this._file.getPath() + " found. We created a split client that returns default treatments for all features for all of your users. If you wish to return a specific treatment for a feature, enter the name of that feature name and treatment name separated by whitespace in " + this._file.getPath() + "; one pair per line. Empty lines or lines starting with '#' are considered comments", (Throwable)e);
        }
        return onSplits;
    }
}

