/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.segments;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SegmentImp {
    private final String _name;
    private final AtomicLong _changeNumber;
    private Set<String> _concurrentKeySet = Collections.newSetFromMap(new ConcurrentHashMap());

    public SegmentImp(long changeNumber, String name) {
        this._name = name;
        this._changeNumber = new AtomicLong(changeNumber);
    }

    public SegmentImp(long changeNumber, String name, List<String> keys) {
        this(changeNumber, name);
        this._concurrentKeySet.addAll(keys);
    }

    public String getName() {
        return this._name;
    }

    public long getChangeNumber() {
        return this._changeNumber.get();
    }

    public void setChangeNumber(long changeNumber) {
        this._changeNumber.set(changeNumber);
    }

    public void update(List<String> toAdd, List<String> toRemove) {
        this._concurrentKeySet.removeAll(toRemove);
        this._concurrentKeySet.addAll(toAdd);
    }

    public boolean contains(String key) {
        return this._concurrentKeySet.contains(key);
    }

    public long getKeysSize() {
        return this._concurrentKeySet.size();
    }
}

