/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.splitter;

import io.split.client.dtos.Partition;
import io.split.client.utils.MurmurHash3;
import java.util.List;

public class Splitter {
    private static final int ALGO_LEGACY = 1;
    private static final int ALGO_MURMUR = 2;

    public static String getTreatment(String key, int seed, List<Partition> partitions, int algo) {
        if (partitions.isEmpty()) {
            return "control";
        }
        if (Splitter.hundredPercentOneTreatment(partitions)) {
            return partitions.get((int)0).treatment;
        }
        return Splitter.getTreatment(Splitter.bucket(Splitter.hash(key, seed, algo)), partitions);
    }

    static long hash(String key, int seed, int algo) {
        switch (algo) {
            case 2: {
                return Splitter.murmur_hash(key, seed);
            }
        }
        return Splitter.legacy_hash(key, seed);
    }

    static long murmur_hash(String key, int seed) {
        return MurmurHash3.murmurhash3_x86_32(key, 0, key.length(), seed);
    }

    public static int getBucket(String key, int seed, int algo) {
        return Splitter.bucket(Splitter.hash(key, seed, algo));
    }

    static int legacy_hash(String key, int seed) {
        int h = 0;
        for (int i = 0; i < key.length(); ++i) {
            h = 31 * h + key.charAt(i);
        }
        return h ^ seed;
    }

    private static String getTreatment(int bucket, List<Partition> partitions) {
        int bucketsCoveredThusFar = 0;
        for (Partition partition : partitions) {
            if ((bucketsCoveredThusFar += partition.size) < bucket) continue;
            return partition.treatment;
        }
        return "control";
    }

    static int bucket(long hash) {
        return (int)(Math.abs(hash % 100L) + 1L);
    }

    private static boolean hundredPercentOneTreatment(List<Partition> partitions) {
        if (partitions.size() != 1) {
            return false;
        }
        return partitions.get((int)0).size == 100;
    }
}

