/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.dtos.ImpressionCount;
import io.split.client.dtos.TestImpressions;
import io.split.client.impressions.ImpressionCounter;
import io.split.client.impressions.ImpressionsManager;
import io.split.client.impressions.ImpressionsSender;
import io.split.client.utils.Utils;
import io.split.telemetry.domain.enums.HTTPLatenciesEnum;
import io.split.telemetry.domain.enums.LastSynchronizationRecordsEnum;
import io.split.telemetry.domain.enums.ResourceEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;

public class HttpImpressionsSender
implements ImpressionsSender {
    private static final String BULK_ENDPOINT_PATH = "api/testImpressions/bulk";
    private static final String COUNT_ENDPOINT_PATH = "api/testImpressions/count";
    private static final String IMPRESSIONS_MODE_HEADER = "SplitSDKImpressionsMode";
    private static final Logger _logger = LoggerFactory.getLogger(HttpImpressionsSender.class);
    private final CloseableHttpClient _client;
    private final URI _impressionBulkTarget;
    private final URI _impressionCountTarget;
    private final ImpressionsManager.Mode _mode;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    public static HttpImpressionsSender create(CloseableHttpClient client, URI eventsRootEndpoint, ImpressionsManager.Mode mode, TelemetryRuntimeProducer telemetryRuntimeProducer) throws URISyntaxException {
        return new HttpImpressionsSender(client, Utils.appendPath(eventsRootEndpoint, BULK_ENDPOINT_PATH), Utils.appendPath(eventsRootEndpoint, COUNT_ENDPOINT_PATH), mode, telemetryRuntimeProducer);
    }

    private HttpImpressionsSender(CloseableHttpClient client, URI impressionBulkTarget, URI impressionCountTarget, ImpressionsManager.Mode mode, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._client = client;
        this._mode = mode;
        this._impressionBulkTarget = impressionBulkTarget;
        this._impressionCountTarget = impressionCountTarget;
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postImpressionsBulk(List<TestImpressions> impressions) {
        CloseableHttpResponse response = null;
        long initTime = System.currentTimeMillis();
        try {
            HttpEntity entity = Utils.toJsonEntity(impressions);
            HttpPost request = new HttpPost(this._impressionBulkTarget);
            request.addHeader(IMPRESSIONS_MODE_HEADER, (Object)this._mode.toString());
            request.setEntity(entity);
            response = this._client.execute((ClassicHttpRequest)request);
            int status = response.getCode();
            if (status < 200 || status >= 300) {
                this._telemetryRuntimeProducer.recordSyncError(ResourceEnum.IMPRESSION_SYNC, status);
                _logger.warn("Response status was: " + status);
            }
            this._telemetryRuntimeProducer.recordSuccessfulSync(LastSynchronizationRecordsEnum.IMPRESSIONS, System.currentTimeMillis());
            this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.IMPRESSIONS, System.currentTimeMillis() - initTime);
        }
        catch (Throwable t) {
            try {
                _logger.warn("Exception when posting impressions" + impressions, t);
                this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.IMPRESSIONS, System.currentTimeMillis() - initTime);
            }
            catch (Throwable throwable) {
                this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.IMPRESSIONS, System.currentTimeMillis() - initTime);
                Utils.forceClose(response);
                throw throwable;
            }
            Utils.forceClose(response);
        }
        Utils.forceClose(response);
    }

    @Override
    public void postCounters(HashMap<ImpressionCounter.Key, Integer> raw) {
        long initTime = System.currentTimeMillis();
        if (this._mode.equals((Object)ImpressionsManager.Mode.DEBUG)) {
            _logger.warn("Attempted to submit counters in impressions debugging mode. Ignoring");
            return;
        }
        HttpPost request = new HttpPost(this._impressionCountTarget);
        request.setEntity(Utils.toJsonEntity(ImpressionCount.fromImpressionCounterData(raw)));
        try (CloseableHttpResponse response = this._client.execute((ClassicHttpRequest)request);){
            int status = response.getCode();
            if (status < 200 || status >= 300) {
                this._telemetryRuntimeProducer.recordSyncError(ResourceEnum.IMPRESSION_COUNT_SYNC, status);
                _logger.warn("Response status was: " + status);
            }
            this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.IMPRESSIONS_COUNT, System.currentTimeMillis() - initTime);
            this._telemetryRuntimeProducer.recordSuccessfulSync(LastSynchronizationRecordsEnum.IMPRESSIONS_COUNT, System.currentTimeMillis());
        }
        catch (IOException exc) {
            _logger.warn("Exception when posting impression counters: ", (Throwable)exc);
        }
    }

    @VisibleForTesting
    URI getTarget() {
        return this._impressionBulkTarget;
    }
}

