/*
 * Decompiled with CFR 0.152.
 */
package io.split.storages.pluggable.domain;

import java.util.ArrayList;
import java.util.List;

public class PrefixAdapter {
    private static final String DEFAULT_PREFIX = "SPLITIO.";
    private static final String SPLIT_PREFIX = "split.";
    private static final String SPLITS_PREFIX = "splits.";
    private static final String TRAFFIC_TYPE_PREFIX = "trafficType.";
    private static final String EVENTS = "events";
    private static final String IMPRESSIONS = "impressions";
    private static final String SEGMENT = "segment.";
    private static final String TILL = "till";
    private static final String TELEMETRY = "telemetry.";
    private static final String LATENCIES = "latencies";
    private static final String EXCEPTIONS = "exceptions";
    private static final String INIT = "init";

    public static String buildSplitKey(String name) {
        return String.format("SPLITIO.split.{%s}", name);
    }

    public static String buildSplitChangeNumber() {
        return "SPLITIO.splits.till";
    }

    public static String buildGetAllSplit() {
        return "SPLITIO.splits.*";
    }

    public static String buildTrafficTypeExists(String trafficType) {
        return String.format("SPLITIO.trafficType.{%s}", trafficType);
    }

    public static List<String> buildFetchManySplits(List<String> names) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String name : names) {
            prefixes.add(String.format("SPLITIO.split.{%s}", name));
        }
        return prefixes;
    }

    public static String buildEvent() {
        return "SPLITIO.events";
    }

    public static String buildImpressions() {
        return "SPLITIO.impressions";
    }

    public static String buildSegment(String segmentName) {
        return String.format("SPLITIO.segment.{%s}", segmentName);
    }

    public static String buildSegmentAll() {
        return String.format("SPLITIO.segment.*", new Object[0]);
    }

    public static String buildSegmentTill(String segmentName) {
        return String.format("SPLITIO.segment.{%s}.till", segmentName);
    }

    public static String buildTelemetryLatenciesPrefix(String method, int bucketForLatency, String sdkVersion, String machineIp, String machineName) {
        return String.format("SPLITIO.telemetry.latencies::{%s}/{%s}/{%s}/{%s}/{%d}", sdkVersion, machineName, machineIp, method, bucketForLatency);
    }

    public static String buildTelemetryExceptionsPrefix(String method, String sdkVersion, String machineIp, String machineName) {
        return String.format("SPLITIO.telemetry.exceptions::{%s}/{%s}/{%s}/{%s}", sdkVersion, machineName, machineIp, method);
    }

    public static String buildTelemetryInit(String sdkVersion, String machineIp, String machineName) {
        return String.format("SPLITIO.telemetry.init::{%s}/{%s}/{%s}", sdkVersion, machineName, machineIp);
    }
}

