/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.SplitClientConfig;
import io.split.client.dtos.KeyImpression;
import io.split.client.dtos.TestImpressions;
import io.split.client.impressions.HttpImpressionsSender;
import io.split.client.impressions.Impression;
import io.split.client.impressions.ImpressionCounter;
import io.split.client.impressions.ImpressionListener;
import io.split.client.impressions.ImpressionObserver;
import io.split.client.impressions.ImpressionUtils;
import io.split.client.impressions.ImpressionsManager;
import io.split.client.impressions.ImpressionsSender;
import io.split.client.impressions.ImpressionsStorageConsumer;
import io.split.client.impressions.ImpressionsStorageProducer;
import io.split.storages.enums.OperationMode;
import io.split.telemetry.domain.enums.ImpressionsDataTypeEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class ImpressionsManagerImpl
implements ImpressionsManager,
Closeable {
    private static final Logger _log = LoggerFactory.getLogger(ImpressionsManagerImpl.class);
    private static final long BULK_INITIAL_DELAY_SECONDS = 10L;
    private static final long COUNT_INITIAL_DELAY_SECONDS = 100L;
    private static final long COUNT_REFRESH_RATE_SECONDS = 1800L;
    private static final long LAST_SEEN_CACHE_SIZE = 500000L;
    private final SplitClientConfig _config;
    private final ImpressionsStorageProducer _impressionsStorageProducer;
    private final ImpressionsStorageConsumer _impressionsStorageConsumer;
    private final ScheduledExecutorService _scheduler;
    private final ImpressionsSender _impressionsSender;
    private final ImpressionObserver _impressionObserver;
    private final ImpressionCounter _counter;
    private final ImpressionListener _listener;
    private final ImpressionsManager.Mode _mode;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;
    private final boolean _addPreviousTimeEnabled;
    private final boolean _isOptimized;
    private final OperationMode _operationMode;

    public static ImpressionsManagerImpl instance(CloseableHttpClient client, SplitClientConfig config, List<ImpressionListener> listeners, TelemetryRuntimeProducer telemetryRuntimeProducer, ImpressionsStorageConsumer impressionsStorageConsumer, ImpressionsStorageProducer impressionsStorageProducer) throws URISyntaxException {
        return new ImpressionsManagerImpl(client, config, null, listeners, telemetryRuntimeProducer, impressionsStorageConsumer, impressionsStorageProducer);
    }

    public static ImpressionsManagerImpl instanceForTest(CloseableHttpClient client, SplitClientConfig config, ImpressionsSender impressionsSender, List<ImpressionListener> listeners, TelemetryRuntimeProducer telemetryRuntimeProducer, ImpressionsStorageConsumer impressionsStorageConsumer, ImpressionsStorageProducer impressionsStorageProducer) throws URISyntaxException {
        return new ImpressionsManagerImpl(client, config, impressionsSender, listeners, telemetryRuntimeProducer, impressionsStorageConsumer, impressionsStorageProducer);
    }

    private ImpressionsManagerImpl(CloseableHttpClient client, SplitClientConfig config, ImpressionsSender impressionsSender, List<ImpressionListener> listeners, TelemetryRuntimeProducer telemetryRuntimeProducer, ImpressionsStorageConsumer impressionsStorageConsumer, ImpressionsStorageProducer impressionsStorageProducer) throws URISyntaxException {
        this._config = Preconditions.checkNotNull(config);
        this._mode = Preconditions.checkNotNull(config.impressionsMode());
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
        this._impressionsStorageConsumer = Preconditions.checkNotNull(impressionsStorageConsumer);
        this._impressionsStorageProducer = Preconditions.checkNotNull(impressionsStorageProducer);
        this._impressionObserver = new ImpressionObserver(500000L);
        this._impressionsSender = null != impressionsSender ? impressionsSender : HttpImpressionsSender.create(client, URI.create(config.eventsEndpoint()), this._mode, telemetryRuntimeProducer);
        this._scheduler = this.buildExecutor();
        this._scheduler.scheduleAtFixedRate(this::sendImpressions, 10L, config.impressionsRefreshRate(), TimeUnit.SECONDS);
        this._listener = null != listeners && !listeners.isEmpty() ? new ImpressionListener.FederatedImpressionListener(listeners) : new ImpressionListener.NoopImpressionListener();
        this._operationMode = config.operationMode();
        this._addPreviousTimeEnabled = this.shouldAddPreviousTime();
        this._counter = this._addPreviousTimeEnabled ? new ImpressionCounter() : null;
        boolean bl = this._isOptimized = this._counter != null && this.shouldBeOptimized();
        if (this._isOptimized) {
            this._scheduler.scheduleAtFixedRate(this::sendImpressionCounters, 100L, 1800L, TimeUnit.SECONDS);
        }
    }

    private static boolean shouldQueueImpression(Impression i) {
        return Objects.isNull(i.pt()) || ImpressionUtils.truncateTimeframe(i.pt()) != ImpressionUtils.truncateTimeframe(i.time());
    }

    @Override
    public void track(Impression impression) {
        if (null == impression) {
            return;
        }
        impression = this._addPreviousTimeEnabled ? impression.withPreviousTime(this._impressionObserver.testAndSet(impression)) : impression;
        this._listener.log(impression);
        if (this._isOptimized) {
            this._counter.inc(impression.split(), impression.time(), 1);
            if (!ImpressionsManagerImpl.shouldQueueImpression(impression)) {
                this._telemetryRuntimeProducer.recordImpressionStats(ImpressionsDataTypeEnum.IMPRESSIONS_DEDUPED, 1L);
                return;
            }
        }
        if (!this._impressionsStorageProducer.put(KeyImpression.fromImpression(impression))) {
            this._telemetryRuntimeProducer.recordImpressionStats(ImpressionsDataTypeEnum.IMPRESSIONS_DROPPED, 1L);
            return;
        }
        this._telemetryRuntimeProducer.recordImpressionStats(ImpressionsDataTypeEnum.IMPRESSIONS_QUEUED, 1L);
    }

    @Override
    public void close() {
        try {
            this._listener.close();
            _log.info("Successful shutdown of ImpressionListener");
            this._scheduler.shutdown();
            this.sendImpressions();
            this._scheduler.awaitTermination(this._config.waitBeforeShutdown(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            _log.warn("Unable to close ImpressionsManager properly", (Throwable)e);
        }
    }

    @VisibleForTesting
    void sendImpressions() {
        if (this._impressionsStorageConsumer.isFull()) {
            _log.warn("Split SDK impressions queue is full. Impressions may have been dropped. Consider increasing capacity.");
        }
        long start = System.currentTimeMillis();
        List<KeyImpression> impressions = this._impressionsStorageConsumer.pop();
        if (impressions.isEmpty()) {
            return;
        }
        this._impressionsSender.postImpressionsBulk(TestImpressions.fromKeyImpressions(impressions));
        if (this._config.debugEnabled()) {
            _log.info(String.format("Posting %d Split impressions took %d millis", impressions.size(), System.currentTimeMillis() - start));
        }
    }

    @VisibleForTesting
    void sendImpressionCounters() {
        if (!this._counter.isEmpty()) {
            this._impressionsSender.postCounters(this._counter.popAll());
        }
    }

    private ScheduledExecutorService buildExecutor() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Split-ImpressionsManager-%d").build();
        return Executors.newScheduledThreadPool(2, threadFactory);
    }

    private boolean shouldAddPreviousTime() {
        switch (this._operationMode) {
            case STANDALONE: {
                return true;
            }
        }
        return false;
    }

    private boolean shouldBeOptimized() {
        if (!this._addPreviousTimeEnabled) {
            return false;
        }
        switch (this._mode) {
            case OPTIMIZED: {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    ImpressionCounter getCounter() {
        return this._counter;
    }
}

