/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.interceptors;

import java.io.IOException;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import split.com.google.common.base.Preconditions;

public class AuthorizationInterceptorFilter
implements HttpRequestInterceptor {
    static final String AUTHORIZATION_HEADER = "Authorization";
    private final String _apiTokenBearer;

    public static AuthorizationInterceptorFilter instance(String apiToken) {
        return new AuthorizationInterceptorFilter(apiToken);
    }

    private AuthorizationInterceptorFilter(String apiToken) {
        this._apiTokenBearer = "Bearer " + Preconditions.checkNotNull(apiToken);
    }

    public void process(HttpRequest httpRequest, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
        httpRequest.addHeader(AUTHORIZATION_HEADER, (Object)this._apiTokenBearer);
    }
}

