/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.evaluator;

import io.split.client.dtos.ConditionType;
import io.split.client.exceptions.ChangeNumberExceptionWrapper;
import io.split.engine.evaluator.EvaluationContext;
import io.split.engine.evaluator.Evaluator;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.splitter.Splitter;
import io.split.storages.SegmentCacheConsumer;
import io.split.storages.SplitCacheConsumer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class EvaluatorImp
implements Evaluator {
    private static final Logger _log = LoggerFactory.getLogger(EvaluatorImp.class);
    private final SegmentCacheConsumer _segmentCacheConsumer;
    private final EvaluationContext _evaluationContext;
    private final SplitCacheConsumer _splitCacheConsumer;

    public EvaluatorImp(SplitCacheConsumer splitCacheConsumer, SegmentCacheConsumer segmentCache) {
        this._splitCacheConsumer = Preconditions.checkNotNull(splitCacheConsumer);
        this._segmentCacheConsumer = Preconditions.checkNotNull(segmentCache);
        this._evaluationContext = new EvaluationContext(this, this._segmentCacheConsumer);
    }

    @Override
    public TreatmentLabelAndChangeNumber evaluateFeature(String matchingKey, String bucketingKey, String split, Map<String, Object> attributes) {
        try {
            ParsedSplit parsedSplit = this._splitCacheConsumer.get(split);
            if (parsedSplit == null) {
                return new TreatmentLabelAndChangeNumber("control", "definition not found");
            }
            return this.getTreatment(matchingKey, bucketingKey, parsedSplit, attributes);
        }
        catch (ChangeNumberExceptionWrapper e) {
            _log.error("Evaluator Exception", (Throwable)e.wrappedException());
            return new TreatmentLabelAndChangeNumber("control", "exception", e.changeNumber());
        }
        catch (Exception e) {
            _log.error("Evaluator Exception", (Throwable)e);
            return new TreatmentLabelAndChangeNumber("control", "exception");
        }
    }

    private TreatmentLabelAndChangeNumber getTreatment(String matchingKey, String bucketingKey, ParsedSplit parsedSplit, Map<String, Object> attributes) throws ChangeNumberExceptionWrapper {
        try {
            if (parsedSplit.killed()) {
                String config = parsedSplit.configurations() != null ? parsedSplit.configurations().get(parsedSplit.defaultTreatment()) : null;
                return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), "killed", parsedSplit.changeNumber(), config);
            }
            boolean inRollout = false;
            String bk = bucketingKey == null ? matchingKey : bucketingKey;
            for (ParsedCondition parsedCondition : parsedSplit.parsedConditions()) {
                if (!inRollout && parsedCondition.conditionType() == ConditionType.ROLLOUT) {
                    int bucket;
                    if (parsedSplit.trafficAllocation() < 100 && (bucket = Splitter.getBucket(bk, parsedSplit.trafficAllocationSeed(), parsedSplit.algo())) > parsedSplit.trafficAllocation()) {
                        String config = parsedSplit.configurations() != null ? parsedSplit.configurations().get(parsedSplit.defaultTreatment()) : null;
                        return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), "not in split", parsedSplit.changeNumber(), config);
                    }
                    inRollout = true;
                }
                if (!parsedCondition.matcher().match(matchingKey, bucketingKey, attributes, this._evaluationContext)) continue;
                String treatment = Splitter.getTreatment(bk, parsedSplit.seed(), parsedCondition.partitions(), parsedSplit.algo());
                String config = parsedSplit.configurations() != null ? parsedSplit.configurations().get(treatment) : null;
                return new TreatmentLabelAndChangeNumber(treatment, parsedCondition.label(), parsedSplit.changeNumber(), config);
            }
            String config = parsedSplit.configurations() != null ? parsedSplit.configurations().get(parsedSplit.defaultTreatment()) : null;
            return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), "default rule", parsedSplit.changeNumber(), config);
        }
        catch (Exception e) {
            throw new ChangeNumberExceptionWrapper(e, parsedSplit.changeNumber());
        }
    }

    public static final class TreatmentLabelAndChangeNumber {
        public final String treatment;
        public final String label;
        public final Long changeNumber;
        public final String configurations;

        public TreatmentLabelAndChangeNumber(String treatment, String label) {
            this(treatment, label, null, null);
        }

        public TreatmentLabelAndChangeNumber(String treatment, String label, Long changeNumber) {
            this(treatment, label, changeNumber, null);
        }

        public TreatmentLabelAndChangeNumber(String treatment, String label, Long changeNumber, String configurations) {
            this.treatment = treatment;
            this.label = label;
            this.changeNumber = changeNumber;
            this.configurations = configurations;
        }
    }
}

