/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.segments;

import io.split.engine.SDKReadinessGates;
import io.split.engine.segments.SegmentChangeFetcher;
import io.split.engine.segments.SegmentFetcher;
import io.split.engine.segments.SegmentFetcherImp;
import io.split.engine.segments.SegmentSynchronizationTask;
import io.split.storages.SegmentCacheProducer;
import io.split.storages.SplitCacheConsumer;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.com.google.common.collect.Maps;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class SegmentSynchronizationTaskImp
implements SegmentSynchronizationTask,
Closeable {
    private static final Logger _log = LoggerFactory.getLogger(SegmentSynchronizationTaskImp.class);
    private final SegmentChangeFetcher _segmentChangeFetcher;
    private final AtomicLong _refreshEveryNSeconds;
    private final AtomicBoolean _running;
    private final Object _lock = new Object();
    private final ConcurrentMap<String, SegmentFetcher> _segmentFetchers = Maps.newConcurrentMap();
    private final SegmentCacheProducer _segmentCacheProducer;
    private final SDKReadinessGates _gates;
    private final ScheduledExecutorService _scheduledExecutorService;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;
    private final SplitCacheConsumer _splitCacheConsumer;
    private ScheduledFuture<?> _scheduledFuture;

    public SegmentSynchronizationTaskImp(SegmentChangeFetcher segmentChangeFetcher, long refreshEveryNSeconds, int numThreads, SDKReadinessGates gates, SegmentCacheProducer segmentCacheProducer, TelemetryRuntimeProducer telemetryRuntimeProducer, SplitCacheConsumer splitCacheConsumer) {
        this._segmentChangeFetcher = Preconditions.checkNotNull(segmentChangeFetcher);
        Preconditions.checkArgument(refreshEveryNSeconds >= 0L);
        this._refreshEveryNSeconds = new AtomicLong(refreshEveryNSeconds);
        this._gates = Preconditions.checkNotNull(gates);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("split-segmentFetcher-%d").build();
        this._scheduledExecutorService = Executors.newScheduledThreadPool(numThreads, threadFactory);
        this._running = new AtomicBoolean(false);
        this._segmentCacheProducer = Preconditions.checkNotNull(segmentCacheProducer);
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
        this._splitCacheConsumer = Preconditions.checkNotNull(splitCacheConsumer);
    }

    @Override
    public void run() {
        this.fetchAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeSegment(String segmentName) {
        SegmentFetcher segment = (SegmentFetcher)this._segmentFetchers.get(segmentName);
        if (segment != null) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            segment = (SegmentFetcher)this._segmentFetchers.get(segmentName);
            if (segment != null) {
                return;
            }
            segment = new SegmentFetcherImp(segmentName, this._segmentChangeFetcher, this._gates, this._segmentCacheProducer, this._telemetryRuntimeProducer);
            if (this._running.get()) {
                this._scheduledExecutorService.submit(segment::fetchAll);
            }
            this._segmentFetchers.putIfAbsent(segmentName, segment);
        }
    }

    @Override
    public SegmentFetcher getFetcher(String segmentName) {
        this.initializeSegment(segmentName);
        return (SegmentFetcher)this._segmentFetchers.get(segmentName);
    }

    @Override
    public void startPeriodicFetching() {
        if (this._running.getAndSet(true)) {
            _log.debug("Segments PeriodicFetching is running...");
            return;
        }
        _log.debug("Starting PeriodicFetching Segments ...");
        this._scheduledFuture = this._scheduledExecutorService.scheduleWithFixedDelay(this, 0L, this._refreshEveryNSeconds.get(), TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (!this._running.getAndSet(false) || this._scheduledFuture == null) {
            _log.debug("Segments PeriodicFetching not running...");
            return;
        }
        this._scheduledFuture.cancel(false);
        _log.debug("Stopped PeriodicFetching Segments ...");
    }

    @Override
    public void close() {
        if (this._scheduledExecutorService == null || this._scheduledExecutorService.isShutdown()) {
            return;
        }
        this._scheduledExecutorService.shutdown();
        try {
            if (!this._scheduledExecutorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                _log.info("Executor did not terminate in the specified time.");
                List<Runnable> droppedTasks = this._scheduledExecutorService.shutdownNow();
                _log.info("Executor was abruptly shut down. These tasks will not be executed: " + droppedTasks);
            }
        }
        catch (InterruptedException e) {
            _log.error("Shutdown of SegmentFetchers was interrupted");
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void fetchAll(boolean addCacheHeader) {
        this._splitCacheConsumer.getSegments().forEach(this::initialize);
        for (Map.Entry entry : this._segmentFetchers.entrySet()) {
            SegmentFetcher fetcher = (SegmentFetcher)entry.getValue();
            if (fetcher == null) continue;
            if (addCacheHeader) {
                this._scheduledExecutorService.submit(fetcher::runWhitCacheHeader);
                continue;
            }
            this._scheduledExecutorService.submit(fetcher::fetchAll);
        }
    }

    @Override
    public boolean fetchAllSynchronous() {
        this._splitCacheConsumer.getSegments().forEach(this::initialize);
        List segmentFetchExecutions = this._segmentFetchers.entrySet().stream().map(e -> this._scheduledExecutorService.submit(((SegmentFetcher)e.getValue())::runWhitCacheHeader)).collect(Collectors.toList());
        int failures = segmentFetchExecutions.stream().mapToInt(f -> {
            try {
                return (Boolean)f.get() != false ? 0 : 1;
            }
            catch (InterruptedException e) {
                _log.error(e.getMessage());
            }
            catch (ExecutionException e) {
                _log.error(e.getMessage());
            }
            return 0;
        }).sum();
        return failures == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(String segmentName) {
        SegmentFetcher segment = (SegmentFetcher)this._segmentFetchers.get(segmentName);
        if (segment != null) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            segment = (SegmentFetcher)this._segmentFetchers.get(segmentName);
            if (segment != null) {
                return;
            }
            segment = new SegmentFetcherImp(segmentName, this._segmentChangeFetcher, this._gates, this._segmentCacheProducer, this._telemetryRuntimeProducer);
            this._segmentFetchers.putIfAbsent(segmentName, segment);
        }
    }
}

