/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import io.split.client.dtos.Split;
import io.split.client.dtos.SplitChange;
import io.split.client.dtos.Status;
import io.split.engine.common.FetchOptions;
import io.split.engine.experiments.FetchResult;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.experiments.SplitParser;
import io.split.storages.SplitCacheConsumer;
import io.split.storages.SplitCacheProducer;
import io.split.telemetry.domain.enums.LastSynchronizationRecordsEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class SplitFetcherImp
implements SplitFetcher {
    private static final Logger _log = LoggerFactory.getLogger(SplitFetcherImp.class);
    private final SplitParser _parser;
    private final SplitChangeFetcher _splitChangeFetcher;
    private final SplitCacheConsumer _splitCacheConsumer;
    private final SplitCacheProducer _splitCacheProducer;
    private final Object _lock = new Object();
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    public SplitFetcherImp(SplitChangeFetcher splitChangeFetcher, SplitParser parser, SplitCacheConsumer splitCacheConsumer, SplitCacheProducer splitCacheProducer, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._splitChangeFetcher = Preconditions.checkNotNull(splitChangeFetcher);
        this._parser = Preconditions.checkNotNull(parser);
        this._splitCacheConsumer = Preconditions.checkNotNull(splitCacheConsumer);
        this._splitCacheProducer = Preconditions.checkNotNull(splitCacheProducer);
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
    }

    @Override
    public FetchResult forceRefresh(FetchOptions options) {
        _log.debug("Force Refresh feature flags starting ...");
        long INITIAL_CN = this._splitCacheProducer.getChangeNumber();
        HashSet<String> segments = new HashSet<String>();
        try {
            long end;
            long start;
            do {
                start = this._splitCacheProducer.getChangeNumber();
                segments.addAll(this.runWithoutExceptionHandling(options));
                end = this._splitCacheProducer.getChangeNumber();
                if (INITIAL_CN != start) continue;
                options = new FetchOptions.Builder(options).targetChangeNumber(FetchOptions.DEFAULT_TARGET_CHANGENUMBER).build();
            } while (start < end);
            return new FetchResult(true, segments);
        }
        catch (InterruptedException e) {
            _log.warn("Interrupting split fetcher task");
            Thread.currentThread().interrupt();
            return new FetchResult(false, new HashSet<String>());
        }
        catch (Exception e) {
            _log.error("RefreshableSplitFetcher failed: " + e.getMessage());
            if (_log.isDebugEnabled()) {
                _log.debug("Reason:", (Throwable)e);
            }
            return new FetchResult(false, new HashSet<String>());
        }
    }

    @Override
    public void run() {
        this.forceRefresh(new FetchOptions.Builder().cacheControlHeaders(false).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> runWithoutExceptionHandling(FetchOptions options) throws InterruptedException {
        SplitChange change = this._splitChangeFetcher.fetch(this._splitCacheProducer.getChangeNumber(), options);
        HashSet<String> segments = new HashSet<String>();
        if (change == null) {
            throw new IllegalStateException("SplitChange was null");
        }
        if (change.since != this._splitCacheProducer.getChangeNumber() || change.till < this._splitCacheProducer.getChangeNumber()) {
            return segments;
        }
        if (change.splits.isEmpty()) {
            this._splitCacheProducer.setChangeNumber(change.till);
            return segments;
        }
        Object object = this._lock;
        synchronized (object) {
            if (change.since != this._splitCacheProducer.getChangeNumber() || change.till < this._splitCacheProducer.getChangeNumber()) {
                return segments;
            }
            ArrayList<ParsedSplit> parsedSplits = new ArrayList<ParsedSplit>();
            for (Split split : change.splits) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (split.status != Status.ACTIVE) {
                    this._splitCacheProducer.remove(split.name);
                    continue;
                }
                ParsedSplit parsedSplit = this._parser.parse(split);
                if (parsedSplit == null) {
                    _log.info(String.format("We could not parse the experiment definition for: %s so we are removing it completely to be careful", split.name));
                    this._splitCacheProducer.remove(split.name);
                    _log.debug("Deleted feature: " + split.name);
                    continue;
                }
                segments.addAll(parsedSplit.getSegmentsNames());
                ParsedSplit current = this._splitCacheConsumer.get(split.name);
                if (current != null) {
                    this._splitCacheProducer.remove(split.name);
                }
                parsedSplits.add(parsedSplit);
                _log.debug("Updated feature: " + parsedSplit.feature());
            }
            this._splitCacheProducer.putMany(parsedSplits);
            this._splitCacheProducer.setChangeNumber(change.till);
            this._telemetryRuntimeProducer.recordSuccessfulSync(LastSynchronizationRecordsEnum.SPLITS, System.currentTimeMillis());
        }
        return segments;
    }
}

