/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.dtos;

import io.split.engine.sse.NotificationProcessor;
import io.split.engine.sse.PushStatusTracker;
import io.split.engine.sse.dtos.GenericNotificationData;
import io.split.engine.sse.dtos.IncomingNotification;
import io.split.engine.sse.dtos.OccupancyMetrics;
import io.split.engine.sse.dtos.StatusNotification;

public class OccupancyNotification
extends IncomingNotification
implements StatusNotification {
    private final OccupancyMetrics metrics;

    public OccupancyNotification(GenericNotificationData genericNotificationData) {
        super(IncomingNotification.Type.OCCUPANCY, genericNotificationData.getChannel());
        this.metrics = genericNotificationData.getMetrics();
    }

    public OccupancyMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public void handler(NotificationProcessor notificationProcessor) {
        notificationProcessor.processStatus(this);
    }

    @Override
    public void handlerStatus(PushStatusTracker notificationManagerKeeper) {
        notificationManagerKeeper.handleIncomingOccupancyEvent(this);
    }

    public String toString() {
        try {
            return String.format("Type: %s; Channel: %s; Publishers: %s", new Object[]{this.getType(), this.getChannel(), this.getMetrics().getPublishers()});
        }
        catch (Exception ex) {
            return super.toString();
        }
    }
}

