/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.common;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class FetchOptions {
    public static final Long DEFAULT_TARGET_CHANGENUMBER = -1L;
    private final boolean _cacheControlHeaders;
    private final boolean _fastlyDebugHeader;
    private final long _targetCN;
    private final Function<Map<String, String>, Void> _responseHeadersCallback;

    public boolean cacheControlHeadersEnabled() {
        return this._cacheControlHeaders;
    }

    public boolean fastlyDebugHeaderEnabled() {
        return this._fastlyDebugHeader;
    }

    public long targetCN() {
        return this._targetCN;
    }

    public boolean hasCustomCN() {
        return this._targetCN != DEFAULT_TARGET_CHANGENUMBER;
    }

    public void handleResponseHeaders(Map<String, String> headers) {
        if (Objects.isNull(this._responseHeadersCallback) || Objects.isNull(headers)) {
            return;
        }
        this._responseHeadersCallback.apply(headers);
    }

    private FetchOptions(boolean cacheControlHeaders, long targetCN, Function<Map<String, String>, Void> responseHeadersCallback, boolean fastlyDebugHeader) {
        this._cacheControlHeaders = cacheControlHeaders;
        this._targetCN = targetCN;
        this._responseHeadersCallback = responseHeadersCallback;
        this._fastlyDebugHeader = fastlyDebugHeader;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FetchOptions)) {
            return false;
        }
        FetchOptions other = (FetchOptions)obj;
        return Objects.equals(this._cacheControlHeaders, other._cacheControlHeaders) && Objects.equals(this._fastlyDebugHeader, other._fastlyDebugHeader) && Objects.equals(this._responseHeadersCallback, other._responseHeadersCallback) && Objects.equals(this._targetCN, other._targetCN);
    }

    public int hashCode() {
        return split.com.google.common.base.Objects.hashCode(this._cacheControlHeaders, this._fastlyDebugHeader, this._responseHeadersCallback, this._targetCN);
    }

    public static class Builder {
        private long _targetCN = DEFAULT_TARGET_CHANGENUMBER;
        private boolean _cacheControlHeaders = false;
        private boolean _fastlyDebugHeader = false;
        private Function<Map<String, String>, Void> _responseHeadersCallback = null;

        public Builder() {
        }

        public Builder(FetchOptions opts) {
            this._targetCN = opts._targetCN;
            this._cacheControlHeaders = opts._cacheControlHeaders;
            this._fastlyDebugHeader = opts._fastlyDebugHeader;
            this._responseHeadersCallback = opts._responseHeadersCallback;
        }

        public Builder cacheControlHeaders(boolean on) {
            this._cacheControlHeaders = on;
            return this;
        }

        public Builder fastlyDebugHeader(boolean on) {
            this._fastlyDebugHeader = on;
            return this;
        }

        public Builder responseHeadersCallback(Function<Map<String, String>, Void> callback) {
            this._responseHeadersCallback = callback;
            return this;
        }

        public Builder targetChangeNumber(long targetCN) {
            this._targetCN = targetCN;
            return this;
        }

        public FetchOptions build() {
            return new FetchOptions(this._cacheControlHeaders, this._targetCN, this._responseHeadersCallback, this._fastlyDebugHeader);
        }
    }
}

