/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import io.split.engine.experiments.ParsedCondition;
import io.split.engine.matchers.AttributeMatcher;
import io.split.engine.matchers.UserDefinedSegmentMatcher;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import split.com.google.common.collect.ImmutableList;

public class ParsedSplit {
    private final String _split;
    private final int _seed;
    private final boolean _killed;
    private final String _defaultTreatment;
    private final ImmutableList<ParsedCondition> _parsedCondition;
    private final String _trafficTypeName;
    private final long _changeNumber;
    private final int _trafficAllocation;
    private final int _trafficAllocationSeed;
    private final int _algo;
    private final Map<String, String> _configurations;

    public static ParsedSplit createParsedSplitForTests(String feature, int seed, boolean killed, String defaultTreatment, List<ParsedCondition> matcherAndSplits, String trafficTypeName, long changeNumber, int algo) {
        return new ParsedSplit(feature, seed, killed, defaultTreatment, matcherAndSplits, trafficTypeName, changeNumber, 100, seed, algo, null);
    }

    public static ParsedSplit createParsedSplitForTests(String feature, int seed, boolean killed, String defaultTreatment, List<ParsedCondition> matcherAndSplits, String trafficTypeName, long changeNumber, int algo, Map<String, String> configurations) {
        return new ParsedSplit(feature, seed, killed, defaultTreatment, matcherAndSplits, trafficTypeName, changeNumber, 100, seed, algo, configurations);
    }

    public ParsedSplit(String feature, int seed, boolean killed, String defaultTreatment, List<ParsedCondition> matcherAndSplits, String trafficTypeName, long changeNumber, int trafficAllocation, int trafficAllocationSeed, int algo, Map<String, String> configurations) {
        this._split = feature;
        this._seed = seed;
        this._killed = killed;
        this._defaultTreatment = defaultTreatment;
        this._parsedCondition = ImmutableList.copyOf(matcherAndSplits);
        this._trafficTypeName = trafficTypeName;
        this._changeNumber = changeNumber;
        this._algo = algo;
        if (this._defaultTreatment == null) {
            throw new IllegalArgumentException("DefaultTreatment is null");
        }
        this._trafficAllocation = trafficAllocation;
        this._trafficAllocationSeed = trafficAllocationSeed;
        this._configurations = configurations;
    }

    public String feature() {
        return this._split;
    }

    public int trafficAllocation() {
        return this._trafficAllocation;
    }

    public int trafficAllocationSeed() {
        return this._trafficAllocationSeed;
    }

    public int seed() {
        return this._seed;
    }

    public boolean killed() {
        return this._killed;
    }

    public String defaultTreatment() {
        return this._defaultTreatment;
    }

    public List<ParsedCondition> parsedConditions() {
        return this._parsedCondition;
    }

    public String trafficTypeName() {
        return this._trafficTypeName;
    }

    public long changeNumber() {
        return this._changeNumber;
    }

    public int algo() {
        return this._algo;
    }

    public Map<String, String> configurations() {
        return this._configurations;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._split.hashCode();
        result = 31 * result + (this._seed ^ this._seed >>> 32);
        result = 31 * result + (this._killed ? 1 : 0);
        result = 31 * result + this._defaultTreatment.hashCode();
        result = 31 * result + this._parsedCondition.hashCode();
        result = 31 * result + (this._trafficTypeName == null ? 0 : this._trafficTypeName.hashCode());
        result = 31 * result + (int)(this._changeNumber ^ this._changeNumber >>> 32);
        result = 31 * result + (this._algo ^ this._algo >>> 32);
        result = 31 * result + (this._configurations == null ? 0 : this._configurations.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsedSplit)) {
            return false;
        }
        ParsedSplit other = (ParsedSplit)obj;
        return this._split.equals(other._split) && this._seed == other._seed && this._killed == other._killed && this._defaultTreatment.equals(other._defaultTreatment) && this._parsedCondition.equals(other._parsedCondition) && this._trafficTypeName == null ? other._trafficTypeName == null : (this._trafficTypeName.equals(other._trafficTypeName) && this._changeNumber == other._changeNumber && this._algo == other._algo && this._configurations == null ? other._configurations == null : this._configurations.equals(other._configurations));
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("name:");
        bldr.append(this._split);
        bldr.append(", seed:");
        bldr.append(this._seed);
        bldr.append(", killed:");
        bldr.append(this._killed);
        bldr.append(", default treatment:");
        bldr.append(this._defaultTreatment);
        bldr.append(", parsedConditions:");
        bldr.append(this._parsedCondition);
        bldr.append(", trafficTypeName:");
        bldr.append(this._trafficTypeName);
        bldr.append(", changeNumber:");
        bldr.append(this._changeNumber);
        bldr.append(", algo:");
        bldr.append(this._algo);
        bldr.append(", config:");
        bldr.append(this._configurations);
        return bldr.toString();
    }

    public Set<String> getSegmentsNames() {
        return this.parsedConditions().stream().flatMap(parsedCondition -> parsedCondition.matcher().attributeMatchers().stream()).filter(ParsedSplit::isSegmentMatcher).map(ParsedSplit::asSegmentMatcherForEach).map(UserDefinedSegmentMatcher::getSegmentName).collect(Collectors.toSet());
    }

    private static boolean isSegmentMatcher(AttributeMatcher attributeMatcher) {
        return ((AttributeMatcher.NegatableMatcher)attributeMatcher.matcher()).delegate() instanceof UserDefinedSegmentMatcher;
    }

    private static UserDefinedSegmentMatcher asSegmentMatcherForEach(AttributeMatcher attributeMatcher) {
        return (UserDefinedSegmentMatcher)((AttributeMatcher.NegatableMatcher)attributeMatcher.matcher()).delegate();
    }
}

