/*
 * Decompiled with CFR 0.152.
 */
package io.streammachine.driver.client;

import io.streammachine.driver.client.AuthService;
import io.streammachine.driver.common.CompletableFutureResponseListener;
import io.streammachine.driver.common.WebSocketConsumer;
import io.streammachine.driver.domain.Config;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

class ReceiverService {
    private final String isAliveUri;
    private final URI defaultWsEndpointUri;
    private final HttpClient httpClient;
    private final WebSocketClient wsClient;
    private final AuthService authService;

    public ReceiverService(String billingId, String clientId, String clientSecret, Config config) {
        try {
            this.isAliveUri = String.format("%s://%s%s", config.getEgressScheme(), config.getEgressHost(), config.getEgressHealthEndpoint());
            this.defaultWsEndpointUri = new URI(String.format("%s://%s%s", config.getEgressWsScheme(), config.getEgressHost(), config.getEgressWsEndpoint()));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Malformed URI(s) for " + this.getClass().getCanonicalName(), e);
        }
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        this.httpClient = new HttpClient((SslContextFactory)sslContextFactory);
        this.wsClient = new WebSocketClient(this.httpClient);
        this.authService = AuthService.builder().purpose(this.getClass().getSimpleName()).billingId(billingId).clientId(clientId).clientSecret(clientSecret).config(config).build();
        try {
            this.httpClient.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("An unexpected error occurred while starting a new Receiver for Stream Machine.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveWs(boolean asJson, WebSocketConsumer consumer) {
        URI uri = asJson ? UriBuilder.fromUri((URI)this.defaultWsEndpointUri).queryParam("asJson", new Object[]{true}).build(new Object[0]) : this.defaultWsEndpointUri;
        try {
            try {
                this.wsClient.start();
                ClientUpgradeRequest request = new ClientUpgradeRequest();
                request.setHeader(HttpHeader.AUTHORIZATION.asString(), this.getBearerHeaderValue());
                Future future = this.wsClient.connect((Object)consumer, uri, request);
                Session session = (Session)future.get();
                consumer.awaitClosure();
                session.close();
            }
            finally {
                this.wsClient.stop();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("An unexpected error occurred while trying to (dis)connect via WebSocket.", e);
        }
    }

    public ContentResponse isAlive() {
        CompletableFuture<ContentResponse> completableFuture = new CompletableFuture<ContentResponse>();
        this.httpClient.newRequest(this.isAliveUri).method("GET").header(HttpHeader.AUTHORIZATION, this.getBearerHeaderValue()).send((Response.CompleteListener)new CompletableFutureResponseListener(completableFuture));
        return completableFuture.join();
    }

    private String getBearerHeaderValue() {
        return String.format("Bearer %s", this.authService.getAccessToken());
    }
}

