/*
 * Decompiled with CFR 0.152.
 */
package io.streammachine.driver.client;

import io.streammachine.driver.client.ReceiverService;
import io.streammachine.driver.client.SenderService;
import io.streammachine.driver.common.WebSocketConsumer;
import io.streammachine.driver.domain.Config;
import io.streammachine.driver.serializer.SerializationType;
import io.streammachine.schemas.StreamMachineEvent;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.client.api.ContentResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamMachineClient {
    private static final Logger log = LoggerFactory.getLogger(StreamMachineClient.class);
    private final SenderService senderService;
    private final ReceiverService receiverService;

    public StreamMachineClient(String billingId, String clientId, String clientSecret, Config config) {
        this.senderService = new SenderService(billingId, clientId, clientSecret, config);
        this.receiverService = new ReceiverService(billingId, clientId, clientSecret, config);
    }

    public CompletableFuture<ContentResponse> send(StreamMachineEvent event, SerializationType type) {
        return this.senderService.send(event, type);
    }

    public void startReceivingWs(boolean asJson, WebSocketConsumer consumer) {
        this.receiverService.receiveWs(asJson, consumer);
    }

    public ContentResponse egressIsAlive() {
        return this.receiverService.isAlive();
    }

    public static StreamMachineClientBuilder builder() {
        return new StreamMachineClientBuilder();
    }

    public static class StreamMachineClientBuilder {
        private String billingId;
        private String clientId;
        private String clientSecret;
        private Config config;

        StreamMachineClientBuilder() {
        }

        public StreamMachineClientBuilder billingId(String billingId) {
            this.billingId = billingId;
            return this;
        }

        public StreamMachineClientBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public StreamMachineClientBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public StreamMachineClientBuilder config(Config config) {
            this.config = config;
            return this;
        }

        public StreamMachineClient build() {
            return new StreamMachineClient(this.billingId, this.clientId, this.clientSecret, this.config);
        }

        public String toString() {
            return "StreamMachineClient.StreamMachineClientBuilder(billingId=" + this.billingId + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", config=" + this.config + ")";
        }
    }
}

