/*
 * Decompiled with CFR 0.152.
 */
package io.streammachine.driver.common;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpStatus;

public class CompletableFutureResponseListener
extends BufferingResponseListener {
    private final CompletableFuture<ContentResponse> completable;

    public CompletableFutureResponseListener(CompletableFuture<ContentResponse> completable) {
        this.completable = completable;
    }

    public void onComplete(Result result) {
        if (result.isFailed()) {
            this.completable.completeExceptionally(result.getFailure());
        } else {
            Response response = result.getResponse();
            HttpContentResponse httpContentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
            if (HttpStatus.isSuccess((int)response.getStatus())) {
                this.completable.complete((ContentResponse)httpContentResponse);
            } else {
                this.completable.completeExceptionally((Throwable)new HttpResponseException(this.getContentAsString(), (Response)httpContentResponse));
            }
        }
    }
}

