/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.javaagent;

import io.vproxy.javaagent.AbstractClassTransformer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jdk.internal.org.objectweb.asm.tree.ClassNode;
import jdk.internal.org.objectweb.asm.tree.MethodNode;

public abstract class AbstractMethodTransformer
extends AbstractClassTransformer {
    private final Set<MethodSignature> methods = new HashSet<MethodSignature>();

    public AbstractMethodTransformer(String className, String methodName, String methodDesc) {
        super(className);
        this.methods.add(new MethodSignature(methodName, methodDesc));
    }

    public AbstractMethodTransformer(String className, Collection<MethodSignature> methods) {
        super(className);
        this.methods.addAll(methods);
    }

    @Override
    protected final boolean transform(ClassNode node, String classname) {
        for (MethodNode m : node.methods) {
            if (!this.methods.contains(new MethodSignature(m.name, m.desc))) continue;
            return this.transform(node, classname, m);
        }
        return false;
    }

    protected abstract boolean transform(ClassNode var1, String var2, MethodNode var3);

    public static final class MethodSignature {
        public final String name;
        public final String desc;

        public MethodSignature(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodSignature that = (MethodSignature)o;
            if (!Objects.equals(this.name, that.name)) {
                return false;
            }
            return Objects.equals(this.desc, that.desc);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.desc != null ? this.desc.hashCode() : 0);
            return result;
        }
    }
}

