/*
 * Decompiled with CFR 0.152.
 */
package io.vproxy.javaagent;

import io.vproxy.javaagent.SimpleClassWriter;
import io.vproxy.javaagent.Utils;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.tree.ClassNode;

public abstract class AbstractTransformer
implements ClassFileTransformer {
    private static final int ASM4 = 262144;
    private static final int ASM5 = 327680;
    private static final int ASM6 = 393216;
    private static final int ASM7 = 458752;
    private static final int ASM8 = 524288;
    private static final int[] ASMs = new int[]{524288, 458752, 393216, 327680, 262144};
    private static int ASM_VER = 0;

    private static ClassNode newClassNode() throws IllegalClassFormatException {
        if (ASM_VER != 0) {
            return new ClassNode(ASM_VER);
        }
        for (int asm : ASMs) {
            try {
                ClassNode node = new ClassNode(asm);
                ASM_VER = asm;
                return node;
            }
            catch (Throwable throwable) {
            }
        }
        throw new IllegalClassFormatException("failed to create ClassNode with ASM8|7|6|5|4: " + Arrays.toString(ASMs));
    }

    @Override
    public final byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        boolean transformed;
        ClassNode node;
        try {
            ClassReader reader = new ClassReader(classfileBuffer);
            node = AbstractTransformer.newClassNode();
            reader.accept(node, 0);
        }
        catch (Throwable t) {
            Utils.log("failed to load class " + className + ", please check whether java.base/jdk.internal.org.objectweb.asm and java.base/jdk.internal.org.objectweb.asm.tree are correctly opened");
            Utils.log("sample: --add-opens java.base/jdk.internal.org.objectweb.asm=ALL-UNNAMED --add-opens java.base/jdk.internal.org.objectweb.asm.tree=ALL-UNNAMED");
            Utils.log(t);
            return classfileBuffer;
        }
        try {
            transformed = this.transform(node);
        }
        catch (Throwable t) {
            Utils.log(this.getClass().getName() + ": failed to transform class " + className);
            Utils.log(t);
            return classfileBuffer;
        }
        if (transformed) {
            try {
                SimpleClassWriter writer = new SimpleClassWriter();
                node.accept(writer);
                return writer.toByteArray();
            }
            catch (Throwable t) {
                Utils.log(this.getClass().getName() + ": failed to generate class " + className);
                Utils.log(t);
                return classfileBuffer;
            }
        }
        return classfileBuffer;
    }

    protected abstract boolean transform(ClassNode var1) throws IllegalClassFormatException;
}

