/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Constants {
    private static final Field[] FIELDS = Constants.class.getDeclaredFields();
    private static final int MASK = 25;
    private static final int[] FIELD_VALUES = new int[FIELDS.length];
    private static final Map<String, Integer> CONSTANTS;
    private static final Map<Integer, String> CONSTANTS_STRING;
    public static final int O_RDONLY;
    public static final int O_WRONLY;
    public static final int O_RDWR;
    public static final int O_APPEND;
    public static final int O_CREAT;
    public static final int O_TRUNC;
    public static final int O_EXCL;
    public static final int O_SYNC;
    public static final int O_NOCTTY;
    public static final int S_IRUSR;
    public static final int S_IWUSR;
    public static final int S_IXUSR;
    public static final int S_IRWXU;
    public static final int S_IRGRP;
    public static final int S_IWGRP;
    public static final int S_IXGRP;
    public static final int S_IRWXG;
    public static final int S_IROTH;
    public static final int S_IWOTH;
    public static final int S_IXOTH;
    public static final int S_IRWXO;
    public static final int S_IFMT;
    public static final int S_IFIFO;
    public static final int S_IFCHR;
    public static final int S_IFDIR;
    public static final int S_IFBLK;
    public static final int S_IFREG;
    public static final int S_IFLNK;
    public static final int S_IFSOCK;
    public static final int S_IFWHT;
    public static final int S_ISUID;
    public static final int S_ISGID;
    public static final int S_ISVTX;
    public static final int SIGHUP;
    public static final int SIGINT;
    public static final int SIGQUIT;
    public static final int SIGILL;
    public static final int SIGTRAP;
    public static final int SIGABRT;
    public static final int SIGIOT;
    public static final int SIGBUS;
    public static final int SIGFPE;
    public static final int SIGKILL;
    public static final int SIGUSR1;
    public static final int SIGSEGV;
    public static final int SIGUSR2;
    public static final int SIGPIPE;
    public static final int SIGALRM;
    public static final int SIGTERM;
    public static final int SIGSTKFLT;
    public static final int SIGCHLD;
    public static final int SIGCONT;
    public static final int SIGSTOP;
    public static final int SIGTSTP;
    public static final int SIGTTIN;
    public static final int SIGTTOU;
    public static final int SIGURG;
    public static final int SIGXCPU;
    public static final int SIGXFSZ;
    public static final int SIGVTALRM;
    public static final int SIGPROF;
    public static final int SIGWINCH;
    public static final int SIGIO;
    public static final int SIGPOLL;
    public static final int SIGPWR;
    public static final int SIGSYS;
    public static final int SIGUNUSED;

    public static Map<String, Integer> getConstants() {
        return CONSTANTS;
    }

    public static Map<Integer, String> getConstantsString() {
        return CONSTANTS_STRING;
    }

    private static native void _get_field_values(int[] var0);

    static {
        Constants._get_field_values(FIELD_VALUES);
        O_RDONLY = FIELD_VALUES[0];
        O_WRONLY = FIELD_VALUES[1];
        O_RDWR = FIELD_VALUES[2];
        O_APPEND = FIELD_VALUES[3];
        O_CREAT = FIELD_VALUES[4];
        O_TRUNC = FIELD_VALUES[5];
        O_EXCL = FIELD_VALUES[6];
        O_SYNC = FIELD_VALUES[7];
        O_NOCTTY = FIELD_VALUES[8];
        S_IRUSR = FIELD_VALUES[9];
        S_IWUSR = FIELD_VALUES[10];
        S_IXUSR = FIELD_VALUES[11];
        S_IRWXU = FIELD_VALUES[12];
        S_IRGRP = FIELD_VALUES[13];
        S_IWGRP = FIELD_VALUES[14];
        S_IXGRP = FIELD_VALUES[15];
        S_IRWXG = FIELD_VALUES[16];
        S_IROTH = FIELD_VALUES[17];
        S_IWOTH = FIELD_VALUES[18];
        S_IXOTH = FIELD_VALUES[19];
        S_IRWXO = FIELD_VALUES[20];
        S_IFMT = FIELD_VALUES[21];
        S_IFIFO = FIELD_VALUES[22];
        S_IFCHR = FIELD_VALUES[23];
        S_IFDIR = FIELD_VALUES[24];
        S_IFBLK = FIELD_VALUES[25];
        S_IFREG = FIELD_VALUES[26];
        S_IFLNK = FIELD_VALUES[27];
        S_IFSOCK = FIELD_VALUES[28];
        S_IFWHT = FIELD_VALUES[29];
        S_ISUID = FIELD_VALUES[30];
        S_ISGID = FIELD_VALUES[31];
        S_ISVTX = FIELD_VALUES[32];
        SIGHUP = FIELD_VALUES[33];
        SIGINT = FIELD_VALUES[34];
        SIGQUIT = FIELD_VALUES[35];
        SIGILL = FIELD_VALUES[36];
        SIGTRAP = FIELD_VALUES[37];
        SIGABRT = FIELD_VALUES[38];
        SIGIOT = FIELD_VALUES[39];
        SIGBUS = FIELD_VALUES[40];
        SIGFPE = FIELD_VALUES[41];
        SIGKILL = FIELD_VALUES[42];
        SIGUSR1 = FIELD_VALUES[43];
        SIGSEGV = FIELD_VALUES[44];
        SIGUSR2 = FIELD_VALUES[45];
        SIGPIPE = FIELD_VALUES[46];
        SIGALRM = FIELD_VALUES[47];
        SIGTERM = FIELD_VALUES[48];
        SIGSTKFLT = FIELD_VALUES[49];
        SIGCHLD = FIELD_VALUES[50];
        SIGCONT = FIELD_VALUES[51];
        SIGSTOP = FIELD_VALUES[52];
        SIGTSTP = FIELD_VALUES[53];
        SIGTTIN = FIELD_VALUES[54];
        SIGTTOU = FIELD_VALUES[55];
        SIGURG = FIELD_VALUES[56];
        SIGXCPU = FIELD_VALUES[57];
        SIGXFSZ = FIELD_VALUES[58];
        SIGVTALRM = FIELD_VALUES[59];
        SIGPROF = FIELD_VALUES[60];
        SIGWINCH = FIELD_VALUES[61];
        SIGIO = FIELD_VALUES[62];
        SIGPOLL = FIELD_VALUES[63];
        SIGPWR = FIELD_VALUES[64];
        SIGSYS = FIELD_VALUES[65];
        SIGUNUSED = FIELD_VALUES[66];
        HashMap<String, Integer> constants = new HashMap<String, Integer>(FIELDS.length);
        HashMap<Integer, String> constantsString = new HashMap<Integer, String>(FIELDS.length);
        for (Field f : FIELDS) {
            if ((f.getModifiers() & 0x19) != 25) continue;
            try {
                constants.put(f.getName(), (Integer)f.get(null));
                constantsString.put((Integer)f.get(null), f.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
        CONSTANTS = Collections.unmodifiableMap(constants);
        CONSTANTS_STRING = Collections.unmodifiableMap(constantsString);
    }
}

