/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

public final class NativeException
extends RuntimeException {
    private final int errno;
    private final String errnoString;
    private final String errnoMessage;
    private final String syscall;
    private final String path;

    public NativeException(int errno, String errnoString, String errnoMessage, String syscall, String message, String path) {
        super(message);
        this.errno = errno;
        this.errnoString = errnoString;
        this.errnoMessage = errnoMessage;
        this.syscall = syscall;
        this.path = path;
    }

    public NativeException(String message) {
        super(message);
        this.errno = 0;
        this.errnoString = null;
        this.errnoMessage = null;
        this.syscall = null;
        this.path = null;
    }

    public int errno() {
        return this.errno;
    }

    public String errnoString() {
        return this.errnoString;
    }

    public String getErrnoMessage() {
        return this.errnoMessage;
    }

    public String syscall() {
        return this.syscall;
    }

    public String path() {
        return this.path;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(4096);
        sb.append("errno: ");
        sb.append(this.errno);
        sb.append(", errnoString: ");
        sb.append(this.errnoString);
        sb.append(", errnoMessage: ");
        sb.append(this.errnoMessage);
        if (this.syscall != null && this.syscall.length() > 0) {
            sb.append(", syscall: ");
            sb.append(this.syscall);
        }
        if (this.path != null && this.path.length() > 0) {
            sb.append(", path: ");
            sb.append(this.path);
        }
        sb.append(", message: ");
        sb.append(super.getMessage());
        return sb.toString();
    }

    public static void static_initialize() {
        NativeException._static_initialize();
    }

    private static native void _static_initialize();
}

