/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv.handles;

import com.oracle.libuv.cb.AsyncCallback;
import com.oracle.libuv.handles.Handle;
import com.oracle.libuv.handles.LoopHandle;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncHandle
extends Handle {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private AsyncCallback onSend = null;

    public void setAsyncCallback(AsyncCallback callback) {
        this.onSend = callback;
    }

    protected AsyncHandle(LoopHandle loop) {
        super(AsyncHandle._new(loop.pointer()), loop);
        this._initialize(this.pointer);
    }

    public int send() {
        return this.closed.get() ? -1 : this._send(this.pointer);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this._close(this.pointer);
        }
    }

    private void callSend(int status) {
        if (this.onSend != null) {
            this.loop.getCallbackHandler().handleAsyncCallback(this.onSend, status);
        }
    }

    private static native long _new(long var0);

    private static native void _static_initialize();

    private native void _initialize(long var1);

    private native int _send(long var1);

    private native void _close(long var1);

    static {
        AsyncHandle._static_initialize();
    }
}

