/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv.handles;

import com.oracle.libuv.handles.AsyncHandle;
import com.oracle.libuv.handles.HandleFactory;
import com.oracle.libuv.handles.LoopHandle;
import com.oracle.libuv.handles.PipeHandle;
import com.oracle.libuv.handles.ProcessHandle;
import com.oracle.libuv.handles.TimerHandle;

public class DefaultHandleFactory
implements HandleFactory {
    private LoopHandle loop;

    public static HandleFactory newFactory() {
        return new DefaultHandleFactory().initialize(new LoopHandle());
    }

    @Override
    public HandleFactory initialize(LoopHandle loop) {
        if (this.loop != null) {
            throw new IllegalStateException("already initialized");
        }
        this.loop = loop;
        return this;
    }

    @Override
    public LoopHandle getLoopHandle() {
        return this.loop;
    }

    @Override
    public AsyncHandle newAsyncHandle() {
        assert (this.loop != null);
        return new AsyncHandle(this.loop);
    }

    @Override
    public PipeHandle newPipeHandle(boolean ipc) {
        assert (this.loop != null);
        return new PipeHandle(this.loop, ipc);
    }

    @Override
    public PipeHandle newPipeHandle(long pointer, boolean ipc) {
        assert (this.loop != null);
        return new PipeHandle(this.loop, pointer, ipc);
    }

    @Override
    public ProcessHandle newProcessHandle() {
        assert (this.loop != null);
        return new ProcessHandle(this.loop);
    }

    @Override
    public TimerHandle newTimerHandle() {
        assert (this.loop != null);
        return new TimerHandle(this.loop);
    }
}

