/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv.handles;

import com.oracle.libuv.NativeException;
import com.oracle.libuv.cb.CallbackExceptionHandler;
import com.oracle.libuv.cb.CallbackHandler;
import com.oracle.libuv.cb.CallbackHandlerFactory;
import com.oracle.libuv.cb.ContextProvider;
import com.oracle.libuv.handles.LoopCallbackHandlerFactory;
import java.io.Closeable;

public class LoopHandle
implements Closeable {
    private static int createdLoopCount;
    protected final CallbackExceptionHandler exceptionHandler;
    protected final CallbackHandlerFactory callbackHandlerFactory;
    protected final ContextProvider contextProvider;
    private final long pointer;
    private Throwable pendingException;
    private boolean closed;

    private static synchronized void newLoop() {
        ++createdLoopCount;
    }

    public LoopHandle(CallbackExceptionHandler exceptionHandler, CallbackHandlerFactory callbackHandler, ContextProvider contextProvider) {
        LoopHandle.newLoop();
        this.pointer = LoopHandle._new();
        assert (this.pointer != 0L);
        assert (exceptionHandler != null);
        this.exceptionHandler = exceptionHandler;
        this.callbackHandlerFactory = callbackHandler;
        this.contextProvider = contextProvider;
        this.closed = false;
    }

    public LoopHandle() {
        LoopHandle.newLoop();
        this.pointer = LoopHandle._new();
        assert (this.pointer != 0L);
        this.exceptionHandler = new CallbackExceptionHandler(){

            @Override
            public void handle(Throwable ex) {
                if (LoopHandle.this.pendingException == null) {
                    LoopHandle.this.pendingException = ex;
                } else {
                    LoopHandle.this.pendingException.addSuppressed(ex);
                }
            }
        };
        this.callbackHandlerFactory = new LoopCallbackHandlerFactory(this.exceptionHandler);
        this.contextProvider = new ContextProvider(){

            @Override
            public Object getContext() {
                return null;
            }
        };
    }

    public CallbackHandler getCallbackHandler(Object context) {
        return this.callbackHandlerFactory.newCallbackHandler(context);
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandlerFactory.newCallbackHandler();
    }

    public Object getContext() {
        return this.contextProvider.getContext();
    }

    public CallbackExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public boolean runNoWait() throws Throwable {
        this.throwPendingException();
        return this._run(this.pointer, RunMode.NOWAIT.value) != 0;
    }

    public boolean runOnce() throws Throwable {
        this.throwPendingException();
        return this._run(this.pointer, RunMode.ONCE.value) != 0;
    }

    public boolean run() throws Throwable {
        this.throwPendingException();
        return this._run(this.pointer, RunMode.DEFAULT.value) != 0;
    }

    public void stop() {
        this._stop(this.pointer);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.closeAll();
            this.stop();
        }
    }

    public void destroy() {
        this._destroy(this.pointer);
    }

    public void closeAll() {
        this._close_all(this.pointer);
    }

    public String[] list() {
        return this._list(this.pointer);
    }

    public long pointer() {
        return this.pointer;
    }

    private void throwPendingException() throws Throwable {
        if (this.pendingException != null) {
            Throwable pex = this.pendingException;
            this.pendingException = null;
            throw pex;
        }
    }

    private static native long _new();

    private static native void _static_initialize();

    private native int _run(long var1, int var3);

    private native void _stop(long var1);

    private native void _destroy(long var1);

    private native void _close_all(long var1);

    private native String[] _list(long var1);

    private native NativeException _get_last_error(long var1);

    private native void _set_last_error(long var1, int var3);

    static {
        NativeException.static_initialize();
        LoopHandle._static_initialize();
        createdLoopCount = 0;
    }

    private static enum RunMode {
        DEFAULT(0),
        ONCE(1),
        NOWAIT(2);

        final int value;

        private RunMode(int value) {
            this.value = value;
        }
    }
}

