/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

import com.oracle.libuv.CloseCallback;
import com.oracle.libuv.Handle;
import com.oracle.libuv.LoopHandle;
import com.oracle.libuv.TimerCallback;

public class TimerHandle
extends Handle {
    private boolean closed;
    private TimerCallback onTimerFired;
    private CloseCallback onClose;

    public void setTimerFiredCallback(TimerCallback callback) {
        if (this.onTimerFired != null) {
            throw new IllegalStateException();
        }
        this.onTimerFired = callback;
    }

    public void setCloseCallback(CloseCallback callback) {
        if (this.onClose != null) {
            throw new IllegalStateException();
        }
        this.onClose = callback;
    }

    TimerHandle(LoopHandle loop) {
        super(TimerHandle._new(loop.pointer()), loop);
        this._initialize(this.pointer);
    }

    public static long now(LoopHandle loop) {
        return TimerHandle._now(loop.pointer());
    }

    public int start(long timeout, long repeat) {
        return this._start(this.pointer, timeout, repeat);
    }

    public int again() {
        return this._again(this.pointer);
    }

    public long getRepeat() {
        return this._get_repeat(this.pointer);
    }

    public void setRepeat(long repeat) {
        this._set_repeat(this.pointer, repeat);
    }

    public int stop() {
        return this._stop(this.pointer);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this._close(this.pointer);
        }
        this.closed = true;
    }

    private void callback(int type, int status) {
        switch (type) {
            case 1: {
                if (this.onTimerFired == null) break;
                this.loop.getCallbackHandler().handleTimerCallback(this.onTimerFired, status);
                break;
            }
            case 2: {
                if (this.onClose == null) break;
                this.loop.getCallbackHandler().handleTimerCallback(this.onClose, status);
                break;
            }
            default: {
                assert (false) : "unsupported callback type " + type;
                break;
            }
        }
    }

    private static native long _new(long var0);

    private static native long _now(long var0);

    private static native void _static_initialize();

    private native void _initialize(long var1);

    private native int _start(long var1, long var3, long var5);

    private native int _again(long var1);

    private native long _get_repeat(long var1);

    private native void _set_repeat(long var1, long var3);

    private native int _stop(long var1);

    private native void _close(long var1);

    static {
        TimerHandle._static_initialize();
    }
}

