/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

import com.oracle.libuv.CheckCallback;
import com.oracle.libuv.CloseCallback;
import com.oracle.libuv.Handle;
import com.oracle.libuv.LoopHandle;

public class CheckHandle
extends Handle {
    private boolean closed;
    private CheckCallback onCheck;
    private CloseCallback onClose;

    public void setCheckCallback(CheckCallback callback) {
        if (this.onCheck != null) {
            throw new IllegalStateException();
        }
        this.onCheck = callback;
    }

    public void setCloseCallback(CloseCallback callback) {
        if (this.onClose != null) {
            throw new IllegalStateException();
        }
        this.onClose = callback;
    }

    CheckHandle(LoopHandle loop) {
        super(CheckHandle._new(loop.pointer()), loop);
        this._initialize(this.pointer);
    }

    public int start() {
        return this._start(this.pointer);
    }

    public int stop() {
        return this._stop(this.pointer);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this._close(this.pointer);
        }
        this.closed = true;
    }

    private void callback(int type, int status) {
        switch (type) {
            case 1: {
                if (this.onCheck == null) break;
                this.loop.getCallbackHandler().handleCheckCallback(this.onCheck, status);
                break;
            }
            case 2: {
                if (this.onClose == null) break;
                this.loop.getCallbackHandler().handleCheckCallback(this.onClose, status);
                break;
            }
            default: {
                assert (false) : "unsupported callback type " + type;
                break;
            }
        }
    }

    private static native long _new(long var0);

    private static native void _static_initialize();

    private native void _initialize(long var1);

    private native int _start(long var1);

    private native int _stop(long var1);

    private native void _close(long var1);

    static {
        CheckHandle._static_initialize();
    }
}

