/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

import com.oracle.libuv.Address;
import com.oracle.libuv.AsyncCallback;
import com.oracle.libuv.CallbackExceptionHandler;
import com.oracle.libuv.CallbackHandler;
import com.oracle.libuv.CheckCallback;
import com.oracle.libuv.CloseCallback;
import com.oracle.libuv.DnsCallback;
import com.oracle.libuv.IdleCallback;
import com.oracle.libuv.PrepareCallback;
import com.oracle.libuv.ProcessCloseCallback;
import com.oracle.libuv.ProcessExitCallback;
import com.oracle.libuv.StreamCloseCallback;
import com.oracle.libuv.StreamConnectCallback;
import com.oracle.libuv.StreamConnectionCallback;
import com.oracle.libuv.StreamReadCallback;
import com.oracle.libuv.StreamShutdownCallback;
import com.oracle.libuv.StreamWriteCallback;
import com.oracle.libuv.TimerCallback;
import com.oracle.libuv.UDPCloseCallback;
import com.oracle.libuv.UDPRecvCallback;
import com.oracle.libuv.UDPSendCallback;
import java.nio.ByteBuffer;

public final class LoopCallbackHandler
implements CallbackHandler {
    private final CallbackExceptionHandler exceptionHandler;
    private static final Boolean USE_DIRECT_BYTE_BUFFER = Boolean.parseBoolean(System.getProperty("libuv-java.use.directbytebuffer", Boolean.FALSE.toString()));

    LoopCallbackHandler(CallbackExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void handleAsyncCallback(AsyncCallback cb, int status) {
        try {
            cb.onSend(status);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleCheckCallback(CheckCallback cb, int status) {
        try {
            cb.onCheck(status);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleCheckCallback(CloseCallback cb, int status) {
        try {
            cb.onClose(status);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handlePrepareCallback(PrepareCallback cb, int status) {
        try {
            cb.onPrepare(status);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handlePrepareCallback(CloseCallback cb, int status) {
        try {
            cb.onClose(status);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleStreamReadCallback(StreamReadCallback cb, ByteBuffer data) {
        try {
            if (data != null) {
                ByteBuffer buffer = this.clone(data);
                cb.onRead(buffer);
            } else {
                cb.onRead(data);
            }
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    private ByteBuffer clone(ByteBuffer original) {
        ByteBuffer clone = USE_DIRECT_BYTE_BUFFER != false ? ByteBuffer.allocateDirect(original.capacity()) : ByteBuffer.allocate(original.capacity());
        clone.put(original);
        clone.flip();
        return clone;
    }

    @Override
    public void handleStreamWriteCallback(StreamWriteCallback cb, int status, Exception error) {
        try {
            cb.onWrite(status, error);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleStreamConnectCallback(StreamConnectCallback cb, int status, Exception error) {
        try {
            cb.onConnect(status, error);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleStreamConnectionCallback(StreamConnectionCallback cb, int status, Exception error) {
        try {
            cb.onConnection(status, error);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleStreamCloseCallback(StreamCloseCallback cb) {
        try {
            cb.onClose();
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleStreamShutdownCallback(StreamShutdownCallback cb, int status, Exception error) {
        try {
            cb.onShutdown(status, error);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleProcessCloseCallback(ProcessCloseCallback cb) {
        try {
            cb.onClose();
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleProcessExitCallback(ProcessExitCallback cb, int status, int signal, Exception error) {
        try {
            cb.onExit(status, signal, error);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleTimerCallback(TimerCallback cb, int status) {
        try {
            cb.onTimer(status);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleTimerCallback(CloseCallback cb, int status) {
        try {
            cb.onClose(status);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleUDPRecvCallback(UDPRecvCallback cb, int nread, ByteBuffer data, Address address) {
        try {
            if (data != null) {
                ByteBuffer buffer = this.clone(data);
                cb.onRecv(nread, buffer, address);
            } else {
                cb.onRecv(nread, data, address);
            }
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleUDPSendCallback(UDPSendCallback cb, int status, Exception error) {
        try {
            cb.onSend(status, error);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleUDPCloseCallback(UDPCloseCallback cb) {
        try {
            cb.onClose();
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleIdleCallback(IdleCallback cb, int status) {
        try {
            cb.onIdle(status);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleIdleCallback(CloseCallback cb, int status) {
        try {
            cb.onClose(status);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleDnsCallback(DnsCallback cb, Address address, int status) {
        try {
            cb.onAddress(address, status);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }
}

