/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

import com.oracle.libuv.AsyncCallback;
import com.oracle.libuv.Handle;
import com.oracle.libuv.LoopHandle;
import java.util.concurrent.atomic.AtomicBoolean;

public class AsyncHandle
extends Handle {
    private final AtomicBoolean closed = new AtomicBoolean();
    private AsyncCallback onSend;

    public void setAsyncCallback(AsyncCallback callback) {
        if (this.onSend != null) {
            throw new IllegalStateException();
        }
        this.onSend = callback;
    }

    AsyncHandle(LoopHandle loop) {
        super(AsyncHandle._new(loop.pointer()), loop);
        this._initialize(this.pointer);
    }

    public int send() {
        return this.closed.get() ? -1 : this._send(this.pointer);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this._close(this.pointer);
        }
    }

    private void callSend(int status) {
        if (this.onSend != null) {
            this.loop.getCallbackHandler().handleAsyncCallback(this.onSend, status);
        }
    }

    private static native long _new(long var0);

    private static native void _static_initialize();

    private native void _initialize(long var1);

    private native int _send(long var1);

    private native void _close(long var1);

    static {
        AsyncHandle._static_initialize();
    }
}

