/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

import com.oracle.libuv.Address;
import com.oracle.libuv.DnsCallback;
import com.oracle.libuv.LoopHandle;
import java.util.Objects;

public class DNSHandle {
    private final long pointer;
    private final LoopHandle loop;
    private DnsCallback onDns;
    private final String host;
    private final int port;
    private boolean executed;

    DNSHandle(LoopHandle loop, String host, int port) {
        Objects.requireNonNull(loop);
        Objects.requireNonNull(host);
        if (port > 65535 || port < 0) {
            throw new IllegalArgumentException("Invalid port number: [" + port + "]");
        }
        this.host = host;
        this.port = port;
        this.loop = loop;
        this.pointer = DNSHandle._new(loop.pointer());
        this._initialize(this.pointer);
    }

    public void setDnsCallback(DnsCallback callback) {
        if (this.onDns != null) {
            throw new IllegalStateException();
        }
        this.onDns = callback;
    }

    public int execute() {
        if (this.executed) {
            throw new IllegalStateException("DNS Handle can't be used more than once");
        }
        this.executed = true;
        return this._uv_getaddrinfo(this.pointer, this.getHost(), this.port == 0 ? null : String.valueOf(this.port));
    }

    private void callback(Address address, int status) {
        if (this.onDns != null) {
            this.loop.getCallbackHandler().handleDnsCallback(this.onDns, address, status);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    private native void _initialize(long var1);

    private static native long _new(long var0);

    private static native void _static_initialize();

    private native int _uv_getaddrinfo(long var1, String var3, String var4);

    static {
        DNSHandle._static_initialize();
    }
}

