/*
 * Decompiled with CFR 0.152.
 */
package net.mst.utilities.timer;

import net.mst.utilities.timer.Task;

class TimerThread
extends Thread {
    private boolean running = true;
    private boolean paused = false;
    private long interval;
    private int tempIntervalTimes = -1;
    private long tempInterval = -1L;
    private Task task;
    private boolean highPrecision = false;

    public TimerThread(long Interval, Task Task2) {
        this.interval = Interval;
        this.task = Task2;
    }

    public TimerThread(long Interval, Task Task2, boolean highPrecision) {
        this.interval = Interval;
        this.task = Task2;
        this.highPrecision = highPrecision;
    }

    @Override
    public void run() {
        this.waitTime(this.interval);
        while (this.running) {
            if (this.paused) continue;
            long start = System.currentTimeMillis();
            this.task.execute();
            if (this.tempIntervalTimes > 0) {
                --this.tempIntervalTimes;
                if (this.tempInterval <= 0L) continue;
                this.waitTime(this.tempInterval);
                continue;
            }
            this.waitTime(this.interval);
        }
        this.interrupt();
    }

    private void waitTime(long Milliseconds) {
        if (this.highPrecision) {
            this.setPaused(true);
            long end = System.nanoTime() + Milliseconds * 1000000L;
            while (System.nanoTime() < end) {
            }
            this.setPaused(false);
        } else {
            try {
                TimerThread.sleep(Milliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void cancel() {
        this.running = false;
    }

    public void setInterval(Long Interval, Integer Times) {
        if (Times > 0) {
            this.tempIntervalTimes = Times;
            this.tempInterval = Interval;
        } else {
            this.interval = Interval;
        }
    }

    public void setPaused(Boolean isPaused) {
        this.paused = isPaused;
    }

    public void setTask(Task Task2) {
        this.task = Task2;
    }
}

