/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocrPlugins.mseOCR;

import java.awt.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.CharacterRange;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.TrainingImage;
import net.sourceforge.javaocr.scanner.DocumentScanner;
import net.sourceforge.javaocr.scanner.DocumentScannerListener;
import net.sourceforge.javaocr.scanner.DocumentScannerListenerAdaptor;
import net.sourceforge.javaocr.scanner.PixelImage;
import net.sourceforge.javaocr.scanner.accuracy.AccuracyListenerInterface;
import net.sourceforge.javaocr.scanner.accuracy.AccuracyProviderInterface;
import net.sourceforge.javaocr.scanner.accuracy.OCRComp;
import net.sourceforge.javaocr.scanner.accuracy.OCRIdentification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCRScanner
extends DocumentScannerListenerAdaptor
implements AccuracyProviderInterface {
    private static final int BEST_MATCH_STORE_COUNT = 8;
    private StringBuffer decodeBuffer = new StringBuffer();
    private CharacterRange[] acceptableChars;
    private boolean beginningOfRow = false;
    private boolean firstRow = false;
    private String newline = System.getProperty("line.separator");
    private HashMap<Character, ArrayList<TrainingImage>> trainingImages = new HashMap();
    private Character[] bestChars = new Character[8];
    private double[] bestMSEs = new double[8];
    private DocumentScanner documentScanner = new DocumentScanner();
    private AccuracyListenerInterface accListener;
    private static final Logger LOG = Logger.getLogger(OCRScanner.class.getName());

    public void acceptAccuracyListener(AccuracyListenerInterface listener) {
        this.accListener = listener;
    }

    public DocumentScanner getDocumentScanner() {
        return this.documentScanner;
    }

    public void clearTrainingImages() {
        this.trainingImages.clear();
    }

    public void addTrainingImages(HashMap<Character, ArrayList<TrainingImage>> images) {
        for (Character key : images.keySet()) {
            ArrayList<TrainingImage> al = images.get(key);
            ArrayList<TrainingImage> oldAl = this.trainingImages.get(key);
            if (oldAl == null) {
                oldAl = new ArrayList();
                this.trainingImages.put(key, oldAl);
            }
            for (int i = 0; i < al.size(); ++i) {
                oldAl.add(al.get(i));
            }
        }
    }

    public String scan(Image image, int x1, int y1, int x2, int y2, CharacterRange[] acceptableChars) {
        this.acceptableChars = acceptableChars;
        PixelImage pixelImage = new PixelImage(image);
        pixelImage.toGrayScale(true);
        pixelImage.filter();
        this.decodeBuffer.setLength(0);
        this.firstRow = true;
        this.documentScanner.scan(pixelImage, (DocumentScannerListener)this, x1, y1, x2, y2);
        String result = this.decodeBuffer.toString();
        this.decodeBuffer.setLength(0);
        return result;
    }

    public void endRow(PixelImage pixelImage, int y1, int y2) {
        if (this.accListener != null) {
            OCRIdentification identAccuracy = new OCRIdentification(OCRComp.MSE);
            identAccuracy.addChar('\n', 0.0);
            this.accListener.processCharOrSpace(identAccuracy);
        }
    }

    public void beginRow(PixelImage pixelImage, int y1, int y2) {
        this.beginningOfRow = true;
        if (this.firstRow) {
            this.firstRow = false;
        } else {
            this.decodeBuffer.append(this.newline);
        }
    }

    public void processChar(PixelImage pixelImage, int x1, int y1, int x2, int y2, int rowY1, int rowY2) {
        Iterator<Character> it;
        int[] pixels = pixelImage.pixels;
        int w = pixelImage.width;
        int h = pixelImage.height;
        int areaW = x2 - x1;
        int areaH = y2 - y1;
        float aspectRatio = (float)areaW / (float)areaH;
        int rowHeight = rowY2 - rowY1;
        float topWhiteSpaceFraction = (float)(y1 - rowY1) / (float)rowHeight;
        float bottomWhiteSpaceFraction = (float)(rowY2 - y2) / (float)rowHeight;
        if (this.acceptableChars != null) {
            ArrayList<Character> al = new ArrayList<Character>();
            for (int cs = 0; cs < this.acceptableChars.length; ++cs) {
                CharacterRange cr = this.acceptableChars[cs];
                for (int c = cr.min; c <= cr.max; ++c) {
                    Character ch = new Character((char)c);
                    if (al.indexOf(ch) >= 0) continue;
                    al.add(ch);
                }
            }
            it = al.iterator();
        } else {
            it = this.trainingImages.keySet().iterator();
        }
        int bestCount = 0;
        while (it.hasNext()) {
            Character ch = it.next();
            ArrayList<TrainingImage> al = this.trainingImages.get(ch);
            int nimg = al.size();
            if (nimg <= 0) continue;
            double mse = 0.0;
            boolean gotAny = false;
            for (int i = 0; i < nimg; ++i) {
                TrainingImage ti = al.get(i);
                if (!this.isTrainingImageACandidate(aspectRatio, areaW, areaH, topWhiteSpaceFraction, bottomWhiteSpaceFraction, ti)) continue;
                double thisMSE = ti.calcMSE(pixels, w, h, x1, y1, x2, y2);
                if (gotAny && !(thisMSE < mse)) continue;
                gotAny = true;
                mse = thisMSE;
            }
            if (!gotAny) continue;
            boolean inserted = false;
            for (int i = 0; i < bestCount; ++i) {
                if (!(mse < this.bestMSEs[i])) continue;
                for (int j = Math.min(bestCount, 7); j > i; --j) {
                    int k = j - 1;
                    this.bestChars[j] = this.bestChars[k];
                    this.bestMSEs[j] = this.bestMSEs[k];
                }
                this.bestChars[i] = ch;
                this.bestMSEs[i] = mse;
                if (bestCount < 8) {
                    ++bestCount;
                }
                inserted = true;
                break;
            }
            if (inserted || bestCount >= 8) continue;
            this.bestChars[bestCount] = ch;
            this.bestMSEs[bestCount] = mse;
            ++bestCount;
        }
        if (bestCount > 0) {
            this.decodeBuffer.append(this.bestChars[0].charValue());
            if (this.accListener != null) {
                OCRIdentification identAccuracy = new OCRIdentification(OCRComp.MSE);
                for (int i = 0; i < bestCount; ++i) {
                    identAccuracy.addChar(this.bestChars[i].charValue(), this.bestMSEs[i]);
                }
                this.accListener.processCharOrSpace(identAccuracy);
            }
        } else if (this.accListener != null) {
            OCRIdentification identAccuracy = new OCRIdentification(OCRComp.MSE);
            this.accListener.processCharOrSpace(identAccuracy);
        }
    }

    private boolean isTrainingImageACandidate(float aspectRatio, int w, int h, float topWhiteSpaceFraction, float bottomWhiteSpaceFraction, TrainingImage ti) {
        if (aspectRatio / ti.aspectRatio - 1.0f > 0.3f) {
            return false;
        }
        if (ti.aspectRatio / aspectRatio - 1.0f > 0.3f) {
            return false;
        }
        if (Math.abs(topWhiteSpaceFraction - ti.topWhiteSpaceFraction) > 0.3f) {
            return false;
        }
        if (Math.abs(bottomWhiteSpaceFraction - ti.bottomWhiteSpaceFraction) > 0.3f) {
            return false;
        }
        if (w <= 4 && ti.width >= w * 10) {
            return false;
        }
        if (h <= 4 && ti.height >= h * 10) {
            return false;
        }
        if (ti.width <= 4 && w >= ti.width * 10) {
            return false;
        }
        return ti.height > 4 || h < ti.height * 10;
    }

    public void processSpace(PixelImage pixelImage, int x1, int y1, int x2, int y2) {
        this.decodeBuffer.append(' ');
        if (this.accListener != null) {
            OCRIdentification identAccuracy = new OCRIdentification(OCRComp.MSE);
            identAccuracy.addChar(' ', 0.0);
            this.accListener.processCharOrSpace(identAccuracy);
        }
    }
}

