/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.cluster;

import net.sourceforge.javaocr.Image;
import net.sourceforge.javaocr.cluster.FeatureExtractor;

public class CompositeExtractor
implements FeatureExtractor {
    int size;
    FeatureExtractor[] extractors;

    public CompositeExtractor(FeatureExtractor ... extractors) {
        this.extractors = extractors;
        for (FeatureExtractor extractor : extractors) {
            this.size += extractor.getSize();
        }
    }

    public int getSize() {
        return this.size;
    }

    public double[] extract(Image image) {
        double[] features = new double[this.getSize()];
        int idx = 0;
        for (FeatureExtractor extractor : this.extractors) {
            for (double feature : extractor.extract(image)) {
                features[idx++] = feature;
            }
        }
        return features;
    }
}

