/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.plugin.cluster;

import net.sourceforge.javaocr.plugin.cluster.EuclidianDistanceCluster;

public abstract class NormalDistributionCluster
extends EuclidianDistanceCluster {
    double[] quads;
    double[] var;

    protected NormalDistributionCluster() {
    }

    public NormalDistributionCluster(int dimensions) {
        super(dimensions);
        this.quads = new double[dimensions];
    }

    public NormalDistributionCluster(double[] mx, double[] var) {
        super(mx);
        this.var = var;
    }

    public double[] getVar() {
        if (this.var == null) {
            this.var = new double[this.getDimensions()];
            for (int i = 0; i < this.getDimensions(); ++i) {
                this.var[i] = this.getAmountSamples() == 0 ? 0.0 : (this.quads[i] - this.getSum()[i] * this.getSum()[i] / (double)this.getAmountSamples()) / (double)this.getAmountSamples();
            }
        }
        return this.var;
    }

    public void train(double[] samples) {
        super.train(samples);
        this.var = null;
        for (int i = 0; i < this.getDimensions(); ++i) {
            int n = i;
            this.quads[n] = this.quads[n] + samples[i] * samples[i];
        }
    }

    public double[] getQuads() {
        return this.quads;
    }

    public void setQuads(double[] quads) {
        this.quads = quads;
    }

    public void setVar(double[] var) {
        this.var = var;
    }
}

