/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.cpp.cpd;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.impl.javacc.EscapeTranslator;
import net.sourceforge.pmd.lang.ast.impl.javacc.MalformedSourceException;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.TextDocument;

class CppBlockSkipper
extends EscapeTranslator {
    private final Pattern skipStart;
    private final Pattern skipEnd;

    static Pattern compileSkipMarker(String marker) {
        return Pattern.compile("^(?i)" + Pattern.quote(marker), 8);
    }

    CppBlockSkipper(TextDocument original, Pattern skipStartMarker, Pattern skipEndMarker) {
        super(original);
        this.skipStart = skipStartMarker;
        this.skipEnd = skipEndMarker;
    }

    protected int gobbleMaxWithoutEscape(int maxOff) throws MalformedSourceException {
        Matcher end;
        Matcher start = this.skipStart.matcher((CharSequence)this.input).region(this.bufpos, maxOff);
        if (start.find() && (end = this.skipEnd.matcher((CharSequence)this.input).region(start.end(), maxOff)).find()) {
            return this.recordEscape(start.start(), end.end(), Chars.EMPTY);
        }
        return super.gobbleMaxWithoutEscape(maxOff);
    }
}

