/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class ASTVariableDeclaratorId
extends AbstractJavaTypeNode {
    private int arrayDepth;
    private VariableNameDeclaration nameDeclaration;

    public ASTVariableDeclaratorId(int id) {
        super(id);
    }

    public ASTVariableDeclaratorId(JavaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public VariableNameDeclaration getNameDeclaration() {
        return this.nameDeclaration;
    }

    public void setNameDeclaration(VariableNameDeclaration decl) {
        this.nameDeclaration = decl;
    }

    public List<NameOccurrence> getUsages() {
        return (List)this.getScope().getDeclarations().get(this.nameDeclaration);
    }

    public void bumpArrayDepth() {
        ++this.arrayDepth;
    }

    public int getArrayDepth() {
        return this.arrayDepth;
    }

    public boolean isArray() {
        return this.arrayDepth > 0;
    }

    public boolean isExceptionBlockParameter() {
        return this.jjtGetParent().jjtGetParent() instanceof ASTTryStatement;
    }

    public Node getTypeNameNode() {
        if (this.jjtGetParent() instanceof ASTFormalParameter) {
            return this.findTypeNameNode(this.jjtGetParent());
        }
        if (this.jjtGetParent() instanceof ASTLambdaExpression) {
            return null;
        }
        if (this.jjtGetParent().jjtGetParent() instanceof ASTLocalVariableDeclaration || this.jjtGetParent().jjtGetParent() instanceof ASTFieldDeclaration) {
            return this.findTypeNameNode(this.jjtGetParent().jjtGetParent());
        }
        return null;
    }

    public ASTType getTypeNode() {
        if (this.jjtGetParent() instanceof ASTFormalParameter) {
            return ((ASTFormalParameter)this.jjtGetParent()).getTypeNode();
        }
        if (this.jjtGetParent() instanceof ASTLambdaExpression) {
            return null;
        }
        Node n = this.jjtGetParent().jjtGetParent();
        if (n instanceof ASTLocalVariableDeclaration || n instanceof ASTFieldDeclaration) {
            return (ASTType)n.getFirstChildOfType(ASTType.class);
        }
        return null;
    }

    private Node findTypeNameNode(Node node) {
        int i = 0;
        while (node.jjtGetChild(i) instanceof ASTAnnotation) {
            ++i;
        }
        ASTType typeNode = (ASTType)node.jjtGetChild(i);
        return typeNode.jjtGetChild(0);
    }
}

