/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.unnecessary;

import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.util.CollectionUtil;

public class UnnecessaryConversionTemporaryRule
extends AbstractJavaRule {
    private boolean inPrimaryExpressionContext;
    private ASTPrimaryExpression primary;
    private boolean usingPrimitiveWrapperAllocation;
    private static final Set<String> PRIMITIVE_WRAPPERS = CollectionUtil.asSet((Object[])new String[]{"Integer", "Boolean", "Double", "Long", "Short", "Byte", "Float"});

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        if (node.jjtGetNumChildren() == 0 || node.jjtGetChild(0).jjtGetNumChildren() == 0 || !(node.jjtGetChild(0).jjtGetChild(0) instanceof ASTAllocationExpression)) {
            return super.visit(node, data);
        }
        this.inPrimaryExpressionContext = true;
        this.primary = node;
        super.visit(node, data);
        this.inPrimaryExpressionContext = false;
        this.usingPrimitiveWrapperAllocation = false;
        return data;
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        if (!this.inPrimaryExpressionContext || !(node.jjtGetChild(0) instanceof ASTClassOrInterfaceType)) {
            return super.visit(node, data);
        }
        if (!PRIMITIVE_WRAPPERS.contains(node.jjtGetChild(0).getImage())) {
            return super.visit(node, data);
        }
        this.usingPrimitiveWrapperAllocation = true;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTPrimarySuffix node, Object data) {
        if (this.inPrimaryExpressionContext && this.usingPrimitiveWrapperAllocation && node.hasImageEqualTo("toString") && node.jjtGetParent() == this.primary) {
            this.addViolation(data, (Node)node);
        }
        return super.visit(node, data);
    }
}

