/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.java.typeresolution.visitors.PMDASMVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public final class PMDASMClassLoader
extends ClassLoader {
    private static PMDASMClassLoader cachedPMDASMClassLoader;
    private static ClassLoader cachedClassLoader;
    private final Set<String> dontBother = new HashSet<String>();

    public static synchronized PMDASMClassLoader getInstance(ClassLoader parent) {
        if (parent == cachedClassLoader) {
            return cachedPMDASMClassLoader;
        }
        cachedClassLoader = parent;
        cachedPMDASMClassLoader = new PMDASMClassLoader(parent);
        return cachedPMDASMClassLoader;
    }

    private PMDASMClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.dontBother.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            this.dontBother.add(name);
            throw e;
        }
    }

    public synchronized Map<String, String> getImportedClasses(String name) throws ClassNotFoundException {
        if (this.dontBother.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        try {
            ClassReader reader = new ClassReader(this.getResourceAsStream(name.replace('.', '/') + ".class"));
            PMDASMVisitor asmVisitor = new PMDASMVisitor();
            reader.accept((ClassVisitor)asmVisitor, 0);
            List<String> inner = asmVisitor.getInnerClasses();
            if (inner != null && !inner.isEmpty()) {
                inner = new ArrayList<String>(inner);
                for (String str : inner) {
                    reader = new ClassReader(this.getResourceAsStream(str.replace('.', '/') + ".class"));
                    reader.accept((ClassVisitor)asmVisitor, 0);
                }
            }
            return asmVisitor.getPackages();
        }
        catch (IOException e) {
            this.dontBother.add(name);
            throw new ClassNotFoundException(name, e);
        }
    }
}

