/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.AbstractJavaScope;
import net.sourceforge.pmd.lang.java.symboltable.Applier;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.TypeSet;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class SourceFileScope
extends AbstractJavaScope {
    private String packageImage;
    private TypeSet types;

    public SourceFileScope() {
        this("");
    }

    public SourceFileScope(String packageImage) {
        this.packageImage = packageImage;
    }

    public void configureImports(ClassLoader classLoader, List<ASTImportDeclaration> imports) {
        this.types = new TypeSet(classLoader);
        this.types.setASTCompilationUnitPackage(this.packageImage);
        for (ASTImportDeclaration i : imports) {
            if (i.isImportOnDemand()) {
                this.types.addImport(i.getImportedName() + ".*");
                continue;
            }
            this.types.addImport(i.getImportedName());
        }
    }

    public Set<String> getExplicitImports() {
        return this.types != null ? this.types.getExplicitImports() : Collections.emptySet();
    }

    public boolean hasAuxclasspath() {
        return this.types.hasAuxclasspath();
    }

    public Class<?> resolveType(String name) {
        try {
            return this.types.findClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getPackageName() {
        return this.packageImage;
    }

    @Override
    public void addDeclaration(NameDeclaration declaration) {
        if (!(declaration instanceof ClassNameDeclaration)) {
            throw new IllegalArgumentException("A SourceFileScope can only contain classes.");
        }
        super.addDeclaration(declaration);
    }

    public Map<ClassNameDeclaration, List<NameOccurrence>> getClassDeclarations() {
        return this.getDeclarations(ClassNameDeclaration.class);
    }

    public String toString() {
        return "SourceFileScope: " + this.glomNames(this.getClassDeclarations().keySet());
    }

    @Override
    protected NameDeclaration findVariableHere(JavaNameOccurrence occ) {
        ImageFinderFunction finder = new ImageFinderFunction(occ.getImage());
        Applier.apply(finder, this.getDeclarations().keySet().iterator());
        return finder.getDecl();
    }

    public Map<String, Node> getQualifiedTypeNames() {
        return this.getSubTypes(null, (Scope)this);
    }

    private Map<String, Node> getSubTypes(String qualifyingName, Scope subType) {
        HashMap<String, Node> types = new HashMap<String, Node>();
        for (ClassNameDeclaration c : subType.getDeclarations(ClassNameDeclaration.class).keySet()) {
            String typeName = c.getName();
            if (qualifyingName != null) {
                typeName = qualifyingName + "." + typeName;
            }
            types.put(typeName, (Node)c.getNode());
            types.putAll(this.getSubTypes(typeName, c.getScope()));
        }
        return types;
    }
}

