/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symboltable.AbstractJavaScope;
import net.sourceforge.pmd.lang.java.symboltable.Applier;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class LocalScope
extends AbstractJavaScope {
    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        return this.getDeclarations(VariableNameDeclaration.class);
    }

    public Set<NameDeclaration> addNameOccurrence(NameOccurrence occurrence) {
        JavaNameOccurrence javaOccurrence = (JavaNameOccurrence)occurrence;
        Set<NameDeclaration> declarations = this.findVariableHere(javaOccurrence);
        if (!declarations.isEmpty() && !javaOccurrence.isThisOrSuper()) {
            for (NameDeclaration decl : declarations) {
                List<NameOccurrence> nameOccurrences = this.getVariableDeclarations().get(decl);
                nameOccurrences.add(javaOccurrence);
                JavaNode n = javaOccurrence.getLocation();
                if (!(n instanceof ASTName)) continue;
                ((ASTName)n).setNameDeclaration(decl);
            }
        }
        return declarations;
    }

    @Override
    public void addDeclaration(NameDeclaration nameDecl) {
        if (!(nameDecl instanceof VariableNameDeclaration) && !(nameDecl instanceof ClassNameDeclaration)) {
            throw new IllegalArgumentException("A LocalScope can contain only VariableNameDeclarations or ClassNameDeclarations. Tried to add " + nameDecl.getClass() + "(" + nameDecl + ")");
        }
        super.addDeclaration(nameDecl);
    }

    @Override
    public Set<NameDeclaration> findVariableHere(JavaNameOccurrence occurrence) {
        HashSet<NameDeclaration> result = new HashSet<NameDeclaration>();
        if (occurrence.isThisOrSuper() || occurrence.isMethodOrConstructorInvocation()) {
            return result;
        }
        ImageFinderFunction finder = new ImageFinderFunction(occurrence.getImage());
        Applier.apply(finder, this.getVariableDeclarations().keySet().iterator());
        if (finder.getDecl() != null) {
            result.add(finder.getDecl());
        }
        return result;
    }

    public String toString() {
        return "LocalScope:" + this.glomNames(this.getVariableDeclarations().keySet());
    }
}

