/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;

public class SingularFieldRule
extends AbstractJavaRule {
    private static final BooleanProperty CHECK_INNER_CLASSES = new BooleanProperty("checkInnerClasses", "Check inner classes", Boolean.valueOf(false), 1.0f);
    private static final BooleanProperty DISALLOW_NOT_ASSIGNMENT = new BooleanProperty("disallowNotAssignment", "Disallow violations where the first usage is not an assignment", Boolean.valueOf(false), 2.0f);
    private boolean lombokImported = false;
    private boolean classHasLombokAnnotation = false;
    private static final String LOMBOK_PACKAGE = "lombok";
    private static final Set<String> LOMBOK_ANNOTATIONS = new HashSet<String>();

    public SingularFieldRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_INNER_CLASSES);
        this.definePropertyDescriptor((PropertyDescriptor)DISALLOW_NOT_ASSIGNMENT);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.lombokImported = false;
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        ASTName name = (ASTName)node.getFirstChildOfType(ASTName.class);
        if (!this.lombokImported && name != null && name.getImage() != null & name.getImage().startsWith(LOMBOK_PACKAGE)) {
            this.lombokImported = true;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        this.classHasLombokAnnotation = this.hasLombokAnnotation(node);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        boolean checkInnerClasses = (Boolean)this.getProperty((PropertyDescriptor)CHECK_INNER_CLASSES);
        boolean disallowNotAssignment = (Boolean)this.getProperty((PropertyDescriptor)DISALLOW_NOT_ASSIGNMENT);
        if (node.isPrivate() && !node.isStatic() && !this.classHasLombokAnnotation && !this.hasLombokAnnotation(node)) {
            for (ASTVariableDeclarator declarator : node.findChildrenOfType(ASTVariableDeclarator.class)) {
                ASTVariableDeclaratorId declaration = (ASTVariableDeclaratorId)declarator.jjtGetChild(0);
                List<NameOccurrence> usages = declaration.getUsages();
                Node decl = null;
                boolean violation = true;
                for (int ix = 0; ix < usages.size(); ++ix) {
                    ASTClassOrInterfaceDeclaration clazz;
                    NameOccurrence no = usages.get(ix);
                    ScopedNode location = no.getLocation();
                    ASTPrimaryExpression primaryExpressionParent = (ASTPrimaryExpression)location.getFirstParentOfType(ASTPrimaryExpression.class);
                    if (ix == 0 && !disallowNotAssignment) {
                        if (primaryExpressionParent.getFirstParentOfType(ASTIfStatement.class) != null) {
                            violation = false;
                            break;
                        }
                        Node potentialStatement = primaryExpressionParent.jjtGetParent();
                        boolean assignmentToField = no.getImage().equals(location.getImage());
                        if (!assignmentToField || !this.isInAssignment(potentialStatement)) {
                            violation = false;
                            break;
                        }
                        if (usages.size() > ix + 1) {
                            ScopedNode secondUsageLocation = usages.get(ix + 1).getLocation();
                            List parentStatements = secondUsageLocation.getParentsOfType(ASTStatementExpression.class);
                            for (ASTStatementExpression statementExpression : parentStatements) {
                                if (statementExpression == null || !statementExpression.equals(potentialStatement)) continue;
                                violation = false;
                                break;
                            }
                        }
                    }
                    if (!checkInnerClasses && (clazz = (ASTClassOrInterfaceDeclaration)location.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)) != null && clazz.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class) != null) {
                        violation = false;
                        break;
                    }
                    if (primaryExpressionParent.jjtGetParent() instanceof ASTSynchronizedStatement) {
                        violation = false;
                        break;
                    }
                    Node method = (Node)location.getFirstParentOfType(ASTMethodDeclaration.class);
                    if (method == null && (method = (Node)location.getFirstParentOfType(ASTConstructorDeclaration.class)) == null && (method = (Node)location.getFirstParentOfType(ASTInitializer.class)) == null) continue;
                    if (decl == null) {
                        decl = method;
                        continue;
                    }
                    if (decl == method || decl.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class) != method.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)) continue;
                    violation = false;
                    break;
                }
                if (!violation || usages.isEmpty()) continue;
                this.addViolation(data, node, new Object[]{declaration.getImage()});
            }
        }
        return data;
    }

    private boolean isInAssignment(Node potentialStatement) {
        if (potentialStatement instanceof ASTStatementExpression) {
            ASTStatementExpression statement = (ASTStatementExpression)potentialStatement;
            ArrayList assignments = new ArrayList();
            statement.findDescendantsOfType(ASTAssignmentOperator.class, assignments, false);
            return !assignments.isEmpty() && "=".equals(((ASTAssignmentOperator)assignments.get(0)).getImage());
        }
        return false;
    }

    private boolean hasLombokAnnotation(Node node) {
        boolean result = false;
        Node parent = node.jjtGetParent();
        List annotations = parent.findChildrenOfType(ASTAnnotation.class);
        for (ASTAnnotation annotation : annotations) {
            String shortName;
            ASTName name = (ASTName)annotation.getFirstDescendantOfType(ASTName.class);
            if (name == null) continue;
            String annotationName = name.getImage();
            if (this.lombokImported) {
                if (!LOMBOK_ANNOTATIONS.contains(annotationName)) continue;
                result = true;
                continue;
            }
            if (!annotationName.startsWith("lombok.") || !LOMBOK_ANNOTATIONS.contains(shortName = annotationName.substring(LOMBOK_PACKAGE.length() + 1))) continue;
            result = true;
        }
        return result;
    }

    static {
        LOMBOK_ANNOTATIONS.add("Data");
        LOMBOK_ANNOTATIONS.add("Getter");
        LOMBOK_ANNOTATIONS.add("Setter");
        LOMBOK_ANNOTATIONS.add("Value");
        LOMBOK_ANNOTATIONS.add("RequiredArgsConstructor");
        LOMBOK_ANNOTATIONS.add("AllArgsConstructor");
        LOMBOK_ANNOTATIONS.add("Builder");
    }
}

