/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameter;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameters;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symboltable.AbstractJavaScope;
import net.sourceforge.pmd.lang.java.symboltable.Applier;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.SimpleTypedNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class ClassScope
extends AbstractJavaScope {
    private static ThreadLocal<Integer> anonymousInnerClassCounter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    private final String className;
    private boolean isEnum;

    public ClassScope(String className) {
        this.className = Objects.requireNonNull(className);
        anonymousInnerClassCounter.set(1);
    }

    public ClassScope() {
        int v = anonymousInnerClassCounter.get();
        this.className = "Anonymous$" + v;
        anonymousInnerClassCounter.set(v + 1);
    }

    public void setIsEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public Map<ClassNameDeclaration, List<NameOccurrence>> getClassDeclarations() {
        return this.getDeclarations(ClassNameDeclaration.class);
    }

    public Map<MethodNameDeclaration, List<NameOccurrence>> getMethodDeclarations() {
        return this.getDeclarations(MethodNameDeclaration.class);
    }

    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        return this.getDeclarations(VariableNameDeclaration.class);
    }

    public Set<NameDeclaration> addNameOccurrence(NameOccurrence occurrence) {
        Set<NameDeclaration> declarations;
        block5: {
            JavaNameOccurrence javaOccurrence;
            block4: {
                javaOccurrence = (JavaNameOccurrence)occurrence;
                declarations = this.findVariableHere(javaOccurrence);
                if (declarations.isEmpty() || !javaOccurrence.isMethodOrConstructorInvocation() && !javaOccurrence.isMethodReference()) break block4;
                for (NameDeclaration decl : declarations) {
                    List<NameOccurrence> nameOccurrences = this.getMethodDeclarations().get(decl);
                    if (nameOccurrences == null) continue;
                    nameOccurrences.add(javaOccurrence);
                    JavaNode n = javaOccurrence.getLocation();
                    if (!(n instanceof ASTName)) continue;
                    ((ASTName)n).setNameDeclaration(decl);
                }
                break block5;
            }
            if (declarations.isEmpty() || javaOccurrence.isThisOrSuper()) break block5;
            for (NameDeclaration decl : declarations) {
                List<NameOccurrence> nameOccurrences = this.getVariableDeclarations().get(decl);
                if (nameOccurrences == null) {
                    for (ClassNameDeclaration innerClass : this.getClassDeclarations().keySet()) {
                        Scope innerClassScope = innerClass.getScope();
                        if (!innerClassScope.contains((NameOccurrence)javaOccurrence)) continue;
                        innerClassScope.addNameOccurrence((NameOccurrence)javaOccurrence);
                    }
                    continue;
                }
                nameOccurrences.add(javaOccurrence);
                JavaNode n = javaOccurrence.getLocation();
                if (!(n instanceof ASTName)) continue;
                ((ASTName)n).setNameDeclaration(decl);
            }
        }
        return declarations;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    protected Set<NameDeclaration> findVariableHere(JavaNameOccurrence occurrence) {
        Map<MethodNameDeclaration, List<NameOccurrence>> methodDeclarations = this.getMethodDeclarations();
        Map<VariableNameDeclaration, List<NameOccurrence>> variableDeclarations = this.getVariableDeclarations();
        if (occurrence.isThisOrSuper() || this.className.equals(occurrence.getImage())) {
            if (variableDeclarations.isEmpty() && methodDeclarations.isEmpty()) {
                return Collections.emptySet();
            }
            if (!variableDeclarations.isEmpty()) {
                return Collections.singleton(variableDeclarations.keySet().iterator().next());
            }
            return Collections.singleton(methodDeclarations.keySet().iterator().next());
        }
        HashSet<NameDeclaration> result = new HashSet<NameDeclaration>();
        if (occurrence.isMethodOrConstructorInvocation()) {
            boolean hasAuxclasspath = ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).hasAuxclasspath();
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                if (!mnd.getImage().equals(occurrence.getImage())) continue;
                List<TypedNameDeclaration> parameterTypes = this.determineParameterTypes(mnd);
                List<TypedNameDeclaration> argumentTypes = this.determineArgumentTypes(occurrence, parameterTypes);
                if (!(mnd.isVarargs() || occurrence.getArgumentCount() != mnd.getParameterCount() || hasAuxclasspath && !parameterTypes.equals(argumentTypes))) {
                    result.add((NameDeclaration)mnd);
                    continue;
                }
                if (!mnd.isVarargs()) continue;
                int varArgIndex = parameterTypes.size() - 1;
                TypedNameDeclaration varArgType = parameterTypes.get(varArgIndex);
                if (varArgIndex != 0 && argumentTypes.size() < varArgIndex || hasAuxclasspath && !parameterTypes.subList(0, varArgIndex).equals(argumentTypes.subList(0, varArgIndex))) continue;
                if (!hasAuxclasspath) {
                    result.add((NameDeclaration)mnd);
                    continue;
                }
                boolean sameType = true;
                for (int i = varArgIndex; i < argumentTypes.size(); ++i) {
                    if (varArgType.equals(argumentTypes.get(i))) continue;
                    sameType = false;
                    break;
                }
                if (!sameType) continue;
                result.add((NameDeclaration)mnd);
            }
            if (this.isEnum && "valueOf".equals(occurrence.getImage())) {
                result.add((NameDeclaration)this.createBuiltInMethodDeclaration("valueOf", "String"));
            }
            return result;
        }
        if (occurrence.isMethodReference()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                if (!mnd.getImage().equals(occurrence.getImage())) continue;
                result.add((NameDeclaration)mnd);
            }
            return result;
        }
        ArrayList<String> images = new ArrayList<String>();
        if (occurrence.getImage() != null) {
            images.add(occurrence.getImage());
            if (occurrence.getImage().startsWith(this.className)) {
                images.add(this.clipClassName(occurrence.getImage()));
            }
        }
        ImageFinderFunction finder = new ImageFinderFunction(images);
        Applier.apply(finder, variableDeclarations.keySet().iterator());
        if (finder.getDecl() != null) {
            result.add(finder.getDecl());
        }
        Map<ClassNameDeclaration, List<NameOccurrence>> classDeclarations = this.getClassDeclarations();
        if (result.isEmpty() && !classDeclarations.isEmpty()) {
            for (ClassNameDeclaration innerClass : this.getClassDeclarations().keySet()) {
                Applier.apply(finder, innerClass.getScope().getDeclarations().keySet().iterator());
                if (finder.getDecl() == null) continue;
                result.add(finder.getDecl());
            }
        }
        return result;
    }

    private MethodNameDeclaration createBuiltInMethodDeclaration(String methodName, String ... parameterTypes) {
        ASTMethodDeclaration methodDeclaration = new ASTMethodDeclaration(21);
        methodDeclaration.setPublic(true);
        methodDeclaration.setScope((Scope)this);
        ASTMethodDeclarator methodDeclarator = new ASTMethodDeclarator(22);
        methodDeclarator.setImage(methodName);
        methodDeclarator.setScope((Scope)this);
        ASTFormalParameters formalParameters = new ASTFormalParameters(23);
        formalParameters.setScope((Scope)this);
        methodDeclaration.jjtAddChild((Node)methodDeclarator, 0);
        methodDeclarator.jjtSetParent(methodDeclaration);
        methodDeclarator.jjtAddChild((Node)formalParameters, 0);
        formalParameters.jjtSetParent((Node)methodDeclarator);
        int parameterCount = parameterTypes.length;
        for (int i = 0; i < parameterCount; ++i) {
            ASTFormalParameter formalParameter = new ASTFormalParameter(24);
            formalParameters.jjtAddChild(formalParameter, i);
            formalParameter.jjtSetParent((Node)formalParameters);
            ASTType type = new ASTType(28);
            formalParameter.jjtAddChild(type, 0);
            type.jjtSetParent(formalParameter);
            ASTReferenceType referenceType = new ASTReferenceType(29);
            type.jjtAddChild(referenceType, 0);
            referenceType.jjtSetParent(type);
            ASTClassOrInterfaceType classOrInterfaceType = new ASTClassOrInterfaceType(30);
            classOrInterfaceType.setImage(parameterTypes[i]);
            referenceType.jjtAddChild(classOrInterfaceType, 0);
            classOrInterfaceType.jjtSetParent(referenceType);
            ASTVariableDeclaratorId variableDeclaratorId = new ASTVariableDeclaratorId(18);
            variableDeclaratorId.setImage("arg" + i);
            formalParameter.jjtAddChild(variableDeclaratorId, 1);
            variableDeclaratorId.jjtSetParent(formalParameter);
        }
        return new MethodNameDeclaration(methodDeclarator);
    }

    private List<TypedNameDeclaration> determineParameterTypes(MethodNameDeclaration mnd) {
        List parameters = mnd.getMethodNameDeclaratorNode().findDescendantsOfType(ASTFormalParameter.class);
        if (parameters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypedNameDeclaration> parameterTypes = new ArrayList<TypedNameDeclaration>(parameters.size());
        SourceFileScope fileScope = (SourceFileScope)this.getEnclosingScope(SourceFileScope.class);
        Map<String, Node> qualifiedTypeNames = fileScope.getQualifiedTypeNames();
        for (ASTFormalParameter p : parameters) {
            String typeImage = p.getTypeNode().getTypeImage();
            typeImage = this.qualifyTypeName(typeImage);
            Node declaringNode = qualifiedTypeNames.get(typeImage);
            Class<?> resolvedType = fileScope.resolveType(typeImage);
            if (resolvedType == null) {
                resolvedType = this.resolveGenericType(p, typeImage);
            }
            parameterTypes.add(new SimpleTypedNameDeclaration(typeImage, resolvedType, this.determineSuper(declaringNode)));
        }
        return parameterTypes;
    }

    private String qualifyTypeName(String typeImage) {
        if (typeImage == null) {
            return null;
        }
        LinkedHashSet<String> qualifiedNames = new LinkedHashSet<String>();
        qualifiedNames.addAll(((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).getQualifiedTypeNames().keySet());
        qualifiedNames.addAll(((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).getExplicitImports());
        int nameLength = typeImage.length();
        for (String qualified : qualifiedNames) {
            int fullLength = qualified.length();
            if (!qualified.endsWith(typeImage) || fullLength != nameLength && qualified.charAt(fullLength - nameLength - 1) != '.') continue;
            return qualified;
        }
        return typeImage;
    }

    private List<TypedNameDeclaration> determineArgumentTypes(JavaNameOccurrence occurrence, List<TypedNameDeclaration> parameterTypes) {
        ASTArgumentList arguments = null;
        Node nextSibling = occurrence.getLocation() instanceof ASTPrimarySuffix ? this.getNextSibling((Node)occurrence.getLocation()) : this.getNextSibling(occurrence.getLocation().jjtGetParent());
        if (nextSibling != null) {
            arguments = (ASTArgumentList)nextSibling.getFirstDescendantOfType(ASTArgumentList.class);
        }
        if (arguments == null) {
            return Collections.emptyList();
        }
        ArrayList<TypedNameDeclaration> argumentTypes = new ArrayList<TypedNameDeclaration>(arguments.jjtGetNumChildren());
        Map<String, Node> qualifiedTypeNames = ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).getQualifiedTypeNames();
        for (int i = 0; i < arguments.jjtGetNumChildren(); ++i) {
            Class<?> typeBound;
            Node argument = arguments.jjtGetChild(i);
            Node child = null;
            boolean isMethodCall = false;
            if (argument.jjtGetNumChildren() > 0 && argument.jjtGetChild(0).jjtGetNumChildren() > 0 && argument.jjtGetChild(0).jjtGetChild(0).jjtGetNumChildren() > 0) {
                child = argument.jjtGetChild(0).jjtGetChild(0).jjtGetChild(0);
                isMethodCall = argument.jjtGetChild(0).jjtGetNumChildren() > 1;
            }
            TypedNameDeclaration type = null;
            if (child instanceof ASTName && !isMethodCall) {
                Scope s;
                ASTName name = (ASTName)child;
                JavaNameOccurrence nameOccurrence = new JavaNameOccurrence(name, name.getImage());
                for (s = name.getScope(); s != null && !s.contains((NameOccurrence)nameOccurrence); s = s.getParent()) {
                }
                if (s != null) {
                    Map vars = s.getDeclarations(VariableNameDeclaration.class);
                    for (VariableNameDeclaration d : vars.keySet()) {
                        if (!d.getImage().equals(name.getImage()) || d.getTypeImage() == null) continue;
                        String typeName = d.getTypeImage();
                        typeName = this.qualifyTypeName(typeName);
                        Node declaringNode = qualifiedTypeNames.get(typeName);
                        type = new SimpleTypedNameDeclaration(typeName, ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).resolveType(typeName), this.determineSuper(declaringNode));
                        break;
                    }
                }
            } else if (child instanceof ASTLiteral) {
                ASTLiteral literal = (ASTLiteral)child;
                if (literal.isCharLiteral()) {
                    type = new SimpleTypedNameDeclaration("char", literal.getType());
                } else if (literal.isStringLiteral()) {
                    type = new SimpleTypedNameDeclaration("String", literal.getType());
                } else if (literal.isFloatLiteral()) {
                    type = new SimpleTypedNameDeclaration("float", literal.getType());
                } else if (literal.isDoubleLiteral()) {
                    type = new SimpleTypedNameDeclaration("double", literal.getType());
                } else if (literal.isIntLiteral()) {
                    type = new SimpleTypedNameDeclaration("int", literal.getType());
                } else if (literal.isLongLiteral()) {
                    type = new SimpleTypedNameDeclaration("long", literal.getType());
                } else if (literal.jjtGetNumChildren() == 1 && literal.jjtGetChild(0) instanceof ASTBooleanLiteral) {
                    type = new SimpleTypedNameDeclaration("boolean", Boolean.TYPE);
                }
            } else if (child instanceof ASTAllocationExpression && child.jjtGetChild(0) instanceof ASTClassOrInterfaceType) {
                ASTClassOrInterfaceType classInterface = (ASTClassOrInterfaceType)child.jjtGetChild(0);
                type = this.convertToSimpleType(classInterface);
            }
            if (type == null && !parameterTypes.isEmpty()) {
                type = parameterTypes.size() > i ? parameterTypes.get(i) : parameterTypes.get(parameterTypes.size() - 1);
            }
            if (type != null && type.getType() == null && (typeBound = this.resolveGenericType(argument, type.getTypeImage())) != null) {
                type = new SimpleTypedNameDeclaration(type.getTypeImage(), typeBound);
            }
            argumentTypes.add(type);
        }
        return argumentTypes;
    }

    private SimpleTypedNameDeclaration determineSuper(Node declaringNode) {
        SimpleTypedNameDeclaration result = null;
        if (declaringNode instanceof ASTClassOrInterfaceDeclaration) {
            ASTExtendsList extendsList;
            ASTClassOrInterfaceDeclaration classDeclaration = (ASTClassOrInterfaceDeclaration)declaringNode;
            ASTImplementsList implementsList = (ASTImplementsList)classDeclaration.getFirstChildOfType(ASTImplementsList.class);
            if (implementsList != null) {
                SimpleTypedNameDeclaration type;
                List types = implementsList.findChildrenOfType(ASTClassOrInterfaceType.class);
                result = type = this.convertToSimpleType(types);
            }
            if ((extendsList = (ASTExtendsList)classDeclaration.getFirstChildOfType(ASTExtendsList.class)) != null) {
                List types = extendsList.findChildrenOfType(ASTClassOrInterfaceType.class);
                SimpleTypedNameDeclaration type = this.convertToSimpleType(types);
                if (result == null) {
                    result = type;
                } else {
                    result.addNext(type);
                }
            }
        }
        return result;
    }

    private SimpleTypedNameDeclaration convertToSimpleType(List<ASTClassOrInterfaceType> types) {
        SimpleTypedNameDeclaration result = null;
        for (ASTClassOrInterfaceType t : types) {
            SimpleTypedNameDeclaration type = this.convertToSimpleType(t);
            if (result == null) {
                result = type;
                continue;
            }
            result.addNext(type);
        }
        return result;
    }

    private SimpleTypedNameDeclaration convertToSimpleType(ASTClassOrInterfaceType t) {
        String typeImage = t.getImage();
        typeImage = this.qualifyTypeName(typeImage);
        Node declaringNode = ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).getQualifiedTypeNames().get(typeImage);
        return new SimpleTypedNameDeclaration(typeImage, ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).resolveType(typeImage), this.determineSuper(declaringNode));
    }

    private Class<?> resolveGenericType(Node argument, String typeImage) {
        ASTClassOrInterfaceDeclaration enclosingClassOrEnum;
        ArrayList<ASTTypeParameter> types = new ArrayList<ASTTypeParameter>();
        ASTClassOrInterfaceBodyDeclaration firstParentOfType = (ASTClassOrInterfaceBodyDeclaration)argument.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class);
        if (firstParentOfType != null) {
            types.addAll(firstParentOfType.findDescendantsOfType(ASTTypeParameter.class));
        }
        if ((enclosingClassOrEnum = (ASTClassOrInterfaceDeclaration)argument.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)) == null) {
            argument.getFirstParentOfType(ASTEnumDeclaration.class);
        }
        ASTTypeParameters classLevelTypeParameters = null;
        if (enclosingClassOrEnum != null) {
            classLevelTypeParameters = (ASTTypeParameters)enclosingClassOrEnum.getFirstChildOfType(ASTTypeParameters.class);
        }
        if (classLevelTypeParameters != null) {
            types.addAll(classLevelTypeParameters.findDescendantsOfType(ASTTypeParameter.class));
        }
        return this.resolveGenericType(typeImage, types);
    }

    private Class<?> resolveGenericType(String typeImage, List<ASTTypeParameter> types) {
        for (ASTTypeParameter type : types) {
            if (!typeImage.equals(type.getImage())) continue;
            ASTClassOrInterfaceType bound = (ASTClassOrInterfaceType)type.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
            if (bound != null) {
                if (bound.getType() != null) {
                    return bound.getType();
                }
                return ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).resolveType(bound.getImage());
            }
            return Object.class;
        }
        return null;
    }

    private Node getNextSibling(Node current) {
        Node nextSibling = null;
        for (int i = 0; i < current.jjtGetParent().jjtGetNumChildren() - 1; ++i) {
            if (current.jjtGetParent().jjtGetChild(i) != current) continue;
            nextSibling = current.jjtGetParent().jjtGetChild(i + 1);
            break;
        }
        return nextSibling;
    }

    public String toString() {
        Map<VariableNameDeclaration, List<NameOccurrence>> variableDeclarations;
        Map<MethodNameDeclaration, List<NameOccurrence>> methodDeclarations;
        StringBuilder res = new StringBuilder("ClassScope (").append(this.className).append("): ");
        Map<ClassNameDeclaration, List<NameOccurrence>> classDeclarations = this.getClassDeclarations();
        if (classDeclarations.isEmpty()) {
            res.append("Inner Classes ").append(this.glomNames(classDeclarations.keySet())).append("; ");
        }
        if (!(methodDeclarations = this.getMethodDeclarations()).isEmpty()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                res.append(mnd.toString());
                int usages = methodDeclarations.get((Object)mnd).size();
                res.append("(begins at line ").append(mnd.getNode().getBeginLine()).append(", ").append(usages).append(" usages)");
                res.append(", ");
            }
        }
        if (!(variableDeclarations = this.getVariableDeclarations()).isEmpty()) {
            res.append("Variables ").append(this.glomNames(variableDeclarations.keySet()));
        }
        return res.toString();
    }

    private String clipClassName(String s) {
        return s.substring(s.indexOf(46) + 1);
    }
}

