/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssertStatement;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class UnnecessaryLocalBeforeReturnRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTMethodDeclaration meth, Object data) {
        if (meth.isVoid() || meth.isAbstract() || meth.isNative()) {
            return data;
        }
        return super.visit(meth, data);
    }

    @Override
    public Object visit(ASTReturnStatement rtn, Object data) {
        ASTName name = (ASTName)rtn.getFirstDescendantOfType(ASTName.class);
        if (name == null) {
            return data;
        }
        if (rtn.findDescendantsOfType(ASTExpression.class).size() > 1 || rtn.findDescendantsOfType(ASTPrimaryExpression.class).size() > 1 || this.isMethodCall(rtn)) {
            return data;
        }
        Map vars = name.getScope().getDeclarations(VariableNameDeclaration.class);
        for (Map.Entry entry : vars.entrySet()) {
            VariableNameDeclaration key = (VariableNameDeclaration)entry.getKey();
            List usages = (List)entry.getValue();
            if (this.hasAssertStatement(key, rtn)) continue;
            for (NameOccurrence occ : usages) {
                if (!occ.getLocation().equals(name) || key.getNode().getBeginLine() != name.getBeginLine() - 1) continue;
                String var = name.getImage();
                if (var.indexOf(46) != -1) {
                    var = var.substring(0, var.indexOf(46));
                }
                this.addViolation(data, (Node)rtn, var);
            }
        }
        return data;
    }

    private boolean isMethodCall(ASTReturnStatement rtn) {
        List suffix = rtn.findDescendantsOfType(ASTPrimarySuffix.class);
        for (ASTPrimarySuffix element : suffix) {
            if (!element.isArguments()) continue;
            return true;
        }
        return false;
    }

    private boolean hasAssertStatement(VariableNameDeclaration variableDeclaration, ASTReturnStatement rtn) {
        ASTBlockStatement blockStatement = (ASTBlockStatement)variableDeclaration.getAccessNodeParent().getFirstParentOfType(ASTBlockStatement.class);
        int startIndex = blockStatement.jjtGetChildIndex() + 1;
        int endIndex = ((ASTBlockStatement)rtn.getFirstParentOfType(ASTBlockStatement.class)).jjtGetChildIndex();
        Node block = blockStatement.jjtGetParent();
        for (int i = startIndex; i < endIndex; ++i) {
            List asserts = block.jjtGetChild(i).findDescendantsOfType(ASTAssertStatement.class);
            for (ASTAssertStatement assertStatement : asserts) {
                List names = assertStatement.findDescendantsOfType(ASTName.class);
                for (ASTName n : names) {
                    if (!n.hasImageEqualTo(variableDeclaration.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

