/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class Search {
    private static final boolean TRACE = false;
    private NameOccurrence occ;
    private Set<NameDeclaration> declarations = new HashSet<NameDeclaration>();

    public Search(JavaNameOccurrence occ) {
        this.occ = occ;
    }

    public void execute() {
        Set<NameDeclaration> found = this.searchUpward(this.occ, this.occ.getLocation().getScope());
        this.declarations.addAll(found);
    }

    public void execute(Scope startingScope) {
        Set<NameDeclaration> found = this.searchUpward(this.occ, startingScope);
        this.declarations.addAll(found);
    }

    public Set<NameDeclaration> getResult() {
        return this.declarations;
    }

    private Set<NameDeclaration> searchUpward(NameOccurrence nameOccurrence, Scope scope) {
        if (!scope.contains(nameOccurrence) && scope.getParent() != null) {
            return this.searchUpward(nameOccurrence, scope.getParent());
        }
        if (scope.contains(nameOccurrence)) {
            return scope.addNameOccurrence(nameOccurrence);
        }
        return new HashSet<NameDeclaration>();
    }
}

