/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;

public final class TypeHelper {
    private TypeHelper() {
    }

    public static boolean isA(TypeNode n, Class<?> clazz) {
        return TypeHelper.subclasses(n, clazz);
    }

    public static boolean isEither(TypeNode n, Class<?> class1, Class<?> class2) {
        return TypeHelper.subclasses(n, class1) || TypeHelper.subclasses(n, class2);
    }

    public static boolean isA(TypedNameDeclaration vnd, Class<?> clazz) {
        Class<?> type = vnd.getType();
        return type != null && type.equals(clazz) || type == null && (clazz.getSimpleName().equals(vnd.getTypeImage()) || clazz.getName().equals(vnd.getTypeImage()));
    }

    public static boolean isEither(TypedNameDeclaration vnd, Class<?> class1, Class<?> class2) {
        return TypeHelper.isA(vnd, class1) || TypeHelper.isA(vnd, class2);
    }

    public static boolean isNeither(TypedNameDeclaration vnd, Class<?> class1, Class<?> class2) {
        return !TypeHelper.isA(vnd, class1) && !TypeHelper.isA(vnd, class2);
    }

    public static boolean subclasses(TypeNode n, Class<?> clazz) {
        Class<?> type = n.getType();
        if (type == null) {
            return clazz.getSimpleName().equals(n.getImage()) || clazz.getName().equals(n.getImage());
        }
        if (type.equals(clazz)) {
            return true;
        }
        List<Class<?>> implementors = Arrays.asList(type.getInterfaces());
        if (implementors.contains(clazz)) {
            return true;
        }
        for (Class<?> superC = type.getSuperclass(); superC != null && !superC.equals(Object.class); superC = superC.getSuperclass()) {
            if (!superC.equals(clazz)) continue;
            return true;
        }
        return false;
    }
}

