/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.rules.imports;

import java.util.Iterator;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.imports.UnusedImportsRule;
import net.sourceforge.pmd.lang.rule.ImportWrapper;

public class UnusedImports
extends UnusedImportsRule {
    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        if (node.isImportOnDemand()) {
            ASTName importedType = (ASTName)node.jjtGetChild(0);
            this.imports.add(new ImportWrapper(importedType.getImage(), null, (Node)node, node.getType(), node.isStatic()));
        } else {
            super.visit(node, data);
        }
        return data;
    }

    @Override
    protected void check(Node node) {
        Class<?> c;
        if (this.imports.isEmpty()) {
            return;
        }
        ImportWrapper candidate = this.getImportWrapper(node);
        Iterator it = this.imports.iterator();
        while (it.hasNext()) {
            ImportWrapper i = (ImportWrapper)it.next();
            if (!i.matches(candidate)) continue;
            it.remove();
            return;
        }
        if (TypeNode.class.isAssignableFrom(node.getClass()) && ((TypeNode)node).getType() != null && (c = ((TypeNode)node).getType()).getPackage() != null && this.imports.contains(candidate = new ImportWrapper(c.getPackage().getName(), null))) {
            this.imports.remove(candidate);
        }
    }
}

