/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.AbstractJavaScope;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.AbstractNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class AccessorMethodGenerationRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        SourceFileScope file = (SourceFileScope)node.getScope().getEnclosingScope(SourceFileScope.class);
        this.analyzeScope(file, data);
        return data;
    }

    private void analyzeScope(AbstractJavaScope file, Object data) {
        for (ClassNameDeclaration classDecl : file.getDeclarations(ClassNameDeclaration.class).keySet()) {
            ClassScope classScope = (ClassScope)classDecl.getScope();
            for (Map.Entry<VariableNameDeclaration, List<NameOccurrence>> entry : classScope.getVariableDeclarations().entrySet()) {
                ASTFieldDeclaration field = (ASTFieldDeclaration)entry.getKey().getNode().getFirstParentOfType(ASTFieldDeclaration.class);
                this.analyzeMember(field, entry.getValue(), classScope, data);
            }
            for (Map.Entry<AbstractNameDeclaration, List<NameOccurrence>> entry : classScope.getMethodDeclarations().entrySet()) {
                ASTMethodDeclaration method = (ASTMethodDeclaration)((MethodNameDeclaration)entry.getKey()).getNode().getFirstParentOfType(ASTMethodDeclaration.class);
                this.analyzeMember(method, entry.getValue(), classScope, data);
            }
            this.analyzeScope(classScope, data);
        }
    }

    public void analyzeMember(AbstractJavaAccessNode node, List<NameOccurrence> occurrences, ClassScope classScope, Object data) {
        if (!node.isPrivate()) {
            return;
        }
        for (NameOccurrence no : occurrences) {
            ClassScope usedAtScope = (ClassScope)no.getLocation().getScope().getEnclosingScope(ClassScope.class);
            if (((Object)((Object)classScope)).equals((Object)usedAtScope)) continue;
            this.addViolation(data, (Node)no.getLocation());
        }
    }
}

