/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.junit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValuePair;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNormalAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.rule.junit.AbstractJUnitRule;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class JUnitTestsShouldIncludeAssertRule
extends AbstractJUnitRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration method, Object data) {
        if (this.isJUnitMethod(method, data) && !this.isExpectAnnotated(method.jjtGetParent())) {
            Scope classScope = method.getScope().getParent();
            Map<String, List<NameOccurrence>> expectables = this.getRuleAnnotatedExpectedExceptions(classScope);
            if (!this.containsExpectOrAssert((Node)method.getBlock(), expectables)) {
                this.addViolation(data, method);
            }
        }
        return data;
    }

    private boolean containsExpectOrAssert(Node n, Map<String, List<NameOccurrence>> expectables) {
        if (n instanceof ASTStatementExpression) {
            if (this.isExpectStatement((ASTStatementExpression)n, expectables) || this.isAssertOrFailStatement((ASTStatementExpression)n) || this.isVerifyStatement((ASTStatementExpression)n)) {
                return true;
            }
        } else {
            for (int i = 0; i < n.jjtGetNumChildren(); ++i) {
                Node c = n.jjtGetChild(i);
                if (!this.containsExpectOrAssert(c, expectables)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, List<NameOccurrence>> getRuleAnnotatedExpectedExceptions(Scope classScope) {
        HashMap<String, List<NameOccurrence>> result = new HashMap<String, List<NameOccurrence>>();
        Map decls = classScope.getDeclarations();
        for (NameDeclaration decl : decls.keySet()) {
            Node type;
            String annot;
            Node parent = decl.getNode().jjtGetParent().jjtGetParent().jjtGetParent();
            if (!parent.hasDescendantOfType(ASTAnnotation.class) || parent.getFirstChildOfType(ASTFieldDeclaration.class) == null || !"Rule".equals(annot = ((ASTMarkerAnnotation)parent.getFirstDescendantOfType(ASTMarkerAnnotation.class)).jjtGetChild(0).getImage()) && !"org.junit.Rule".equals(annot) || !"ExpectedException".equals((type = (Node)parent.getFirstDescendantOfType(ASTReferenceType.class)).jjtGetChild(0).getImage())) continue;
            result.put(decl.getName(), (List<NameOccurrence>)decls.get(decl));
        }
        return result;
    }

    private boolean isExpectAnnotated(Node methodParent) {
        List annotations = methodParent.findDescendantsOfType(ASTNormalAnnotation.class);
        for (ASTNormalAnnotation annotation : annotations) {
            ASTName name = (ASTName)annotation.getFirstChildOfType(ASTName.class);
            if (name == null || !"Test".equals(name.getImage()) && (name.getType() == null || !name.getType().equals(JUNIT4_CLASS))) continue;
            List memberValues = annotation.findDescendantsOfType(ASTMemberValuePair.class);
            for (ASTMemberValuePair pair : memberValues) {
                if (!"expected".equals(pair.getImage())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAssertOrFailStatement(ASTStatementExpression expression) {
        String img;
        Node name;
        ASTPrimaryExpression pe;
        return expression != null && (pe = (ASTPrimaryExpression)expression.getFirstChildOfType(ASTPrimaryExpression.class)) != null && (name = (Node)pe.getFirstDescendantOfType(ASTName.class)) != null && (img = name.getImage()) != null && (img.startsWith("assert") || img.startsWith("fail") || img.startsWith("Assert.assert") || img.startsWith("Assert.fail"));
    }

    private boolean isVerifyStatement(ASTStatementExpression expression) {
        String img;
        Node name;
        ASTPrimaryExpression pe;
        return expression != null && (pe = (ASTPrimaryExpression)expression.getFirstChildOfType(ASTPrimaryExpression.class)) != null && (name = (Node)pe.getFirstDescendantOfType(ASTName.class)) != null && (img = name.getImage()) != null && (img.startsWith("verify") || img.startsWith("Mockito.verify"));
    }

    private boolean isExpectStatement(ASTStatementExpression expression, Map<String, List<NameOccurrence>> expectables) {
        ASTPrimaryExpression pe;
        if (expression != null && (pe = (ASTPrimaryExpression)expression.getFirstChildOfType(ASTPrimaryExpression.class)) != null) {
            Node name = (Node)pe.getFirstDescendantOfType(ASTName.class);
            if (name == null) {
                return false;
            }
            String img = name.getImage();
            if (img.indexOf(".") == -1) {
                return false;
            }
            String varname = img.split("\\.")[0];
            if (!expectables.containsKey(varname)) {
                return false;
            }
            for (NameOccurrence occ : expectables.get(varname)) {
                if (occ.getLocation() != name || !img.startsWith(varname + ".expect")) continue;
                return true;
            }
        }
        return false;
    }
}

