/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.oom.AbstractMetric;
import net.sourceforge.pmd.lang.java.oom.OperationStats;
import net.sourceforge.pmd.lang.java.oom.ParameterizedMetricKey;
import net.sourceforge.pmd.lang.java.oom.api.ClassMetric;
import net.sourceforge.pmd.lang.java.oom.api.ClassMetricKey;
import net.sourceforge.pmd.lang.java.oom.api.MetricVersion;
import net.sourceforge.pmd.lang.java.oom.api.OperationMetricKey;
import net.sourceforge.pmd.lang.java.oom.api.ResultOption;
import net.sourceforge.pmd.lang.java.oom.signature.FieldSigMask;
import net.sourceforge.pmd.lang.java.oom.signature.FieldSignature;
import net.sourceforge.pmd.lang.java.oom.signature.OperationSigMask;
import net.sourceforge.pmd.lang.java.oom.signature.OperationSignature;

class ClassStats {
    private Map<OperationSignature, Map<String, OperationStats>> operations = new HashMap<OperationSignature, Map<String, OperationStats>>();
    private Map<FieldSignature, Set<String>> fields = new HashMap<FieldSignature, Set<String>>();
    private Map<String, ClassStats> nestedClasses = new HashMap<String, ClassStats>();
    private Map<ParameterizedMetricKey, Double> memo = new HashMap<ParameterizedMetricKey, Double>();

    ClassStats() {
    }

    private static double highest(List<Double> values) {
        double highest = Double.NEGATIVE_INFINITY;
        for (double val : values) {
            if (!(val > highest)) continue;
            highest = val;
        }
        return highest;
    }

    private static double average(List<Double> values) {
        return ClassStats.sum(values) / (double)values.size();
    }

    private static double sum(List<Double> values) {
        double sum = 0.0;
        for (double val : values) {
            sum += val;
        }
        return sum;
    }

    ClassStats getNestedClassStats(String className, boolean createIfNotFound) {
        if (createIfNotFound && !this.nestedClasses.containsKey(className)) {
            this.nestedClasses.put(className, new ClassStats());
        }
        return this.nestedClasses.get(className);
    }

    void addOperation(String name, OperationSignature sig) {
        if (!this.operations.containsKey(sig)) {
            this.operations.put(sig, new HashMap());
        }
        this.operations.get(sig).put(name, new OperationStats(name));
    }

    void addField(String name, FieldSignature sig) {
        if (!this.fields.containsKey(sig)) {
            this.fields.put(sig, new HashSet());
        }
        this.fields.get(sig).add(name);
    }

    boolean hasMatchingSig(String name, OperationSigMask mask) {
        for (OperationSignature sig : this.operations.keySet()) {
            if (!mask.covers(sig) || !this.operations.get(sig).containsKey(name)) continue;
            return true;
        }
        return false;
    }

    boolean hasMatchingSig(String name, FieldSigMask mask) {
        for (FieldSignature sig : this.fields.keySet()) {
            if (!mask.covers(sig) || !this.fields.get(sig).contains(name)) continue;
            return true;
        }
        return false;
    }

    double compute(OperationMetricKey key, ASTMethodOrConstructorDeclaration node, String name, boolean force, MetricVersion version) {
        Map<String, OperationStats> sigMap = this.operations.get(OperationSignature.buildFor(node));
        if (sigMap == null) {
            return Double.NaN;
        }
        OperationStats stats = sigMap.get(name);
        return stats == null ? Double.NaN : stats.compute(key, node, force, version);
    }

    double computeWithResultOption(OperationMetricKey key, ASTClassOrInterfaceDeclaration node, boolean force, MetricVersion version, ResultOption option) {
        List<ASTMethodOrConstructorDeclaration> ops = AbstractMetric.findOperations(node, false);
        ArrayList<Double> values = new ArrayList<Double>();
        for (ASTMethodOrConstructorDeclaration op : ops) {
            double val;
            if (!key.getCalculator().supports(op) || (val = this.compute(key, op, op.getQualifiedName().getOperation(), force, version)) == Double.NaN) continue;
            values.add(val);
        }
        switch (option) {
            case SUM: {
                return ClassStats.sum(values);
            }
            case HIGHEST: {
                return ClassStats.highest(values);
            }
            case AVERAGE: {
                return ClassStats.average(values);
            }
        }
        return Double.NaN;
    }

    double compute(ClassMetricKey key, ASTClassOrInterfaceDeclaration node, boolean force, MetricVersion version) {
        ParameterizedMetricKey paramKey = ParameterizedMetricKey.build(key, version);
        Double prev = this.memo.get(paramKey);
        if (!force && prev != null) {
            return prev;
        }
        ClassMetric metric = key.getCalculator();
        double val = metric.computeFor(node, version);
        this.memo.put(paramKey, val);
        return val;
    }
}

